/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.dynamos3;

import cloud.orbit.actors.extensions.StorageExtension;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBConfiguration;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBStorageExtension;
import cloud.orbit.actors.extensions.json.ActorReferenceModule;
import cloud.orbit.actors.extensions.s3.S3Configuration;
import cloud.orbit.actors.extensions.s3.S3StorageExtension;
import cloud.orbit.actors.runtime.DefaultDescriptorFactory;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import com.amazonaws.AmazonServiceException;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class DynamoS3StorageExtension
implements StorageExtension {
    private String name = "default";
    private DynamoDBConfiguration dynamoDBConfiguration = new DynamoDBConfiguration();
    private S3Configuration s3Configuration = new S3Configuration();
    private DynamoDBStorageExtension dynamoDBStorageExtension;
    private S3StorageExtension s3StorageExtension;
    private ObjectMapper mapper = new ObjectMapper();
    private String defaultDynamoTableName = "orbit";
    private String s3BucketName = "orbit-bucket";

    public DynamoS3StorageExtension() {
    }

    public DynamoS3StorageExtension(DynamoDBStorageExtension dynamoDBStorageExtension, S3StorageExtension s3StorageExtension) {
        this.dynamoDBStorageExtension = dynamoDBStorageExtension;
        this.s3StorageExtension = s3StorageExtension;
    }

    public DynamoS3StorageExtension(DynamoDBConfiguration dynamoDBConfiguration, S3Configuration s3Configuration) {
        this.dynamoDBConfiguration = dynamoDBConfiguration;
        this.s3Configuration = s3Configuration;
    }

    public Task<Void> start() {
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new ActorReferenceModule(DefaultDescriptorFactory.get()));
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.setVisibility(this.mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (this.dynamoDBStorageExtension == null) {
            this.dynamoDBStorageExtension = new DynamoDBStorageExtension(this.dynamoDBConfiguration);
            this.dynamoDBStorageExtension.setDefaultTableName(this.defaultDynamoTableName);
        }
        if (this.s3StorageExtension == null) {
            this.s3StorageExtension = new S3StorageExtension(this.s3Configuration);
            this.s3StorageExtension.setBucketName(this.s3BucketName);
        }
        return Task.allOf((CompletableFuture[])new CompletableFuture[]{this.dynamoDBStorageExtension.start(), this.s3StorageExtension.start()});
    }

    public Task<Void> stop() {
        return Task.allOf((CompletableFuture[])new CompletableFuture[]{this.dynamoDBStorageExtension.stop(), this.s3StorageExtension.stop()});
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DynamoDBConfiguration getDynamoDBConfiguration() {
        return this.dynamoDBConfiguration;
    }

    public void setDynamoDBConfiguration(DynamoDBConfiguration dynamoDBConfiguration) {
        this.dynamoDBConfiguration = dynamoDBConfiguration;
    }

    public S3Configuration getS3Configuration() {
        return this.s3Configuration;
    }

    public void setS3Configuration(S3Configuration s3Configuration) {
        this.s3Configuration = s3Configuration;
    }

    public String getDefaultDynamoTableName() {
        return this.defaultDynamoTableName;
    }

    public void setDefaultDynamoTableName(String defaultDynamoTableName) {
        this.defaultDynamoTableName = defaultDynamoTableName;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    private static /* synthetic */ Task lambda$checkCast$cloud_orbit_concurrent_Task(CompletionStage stage) {
        if (stage instanceof Task) {
            return (Task)stage;
        }
        Task t = new Task();
        stage.whenComplete((arg_0, arg_1) -> DynamoS3StorageExtension.lambda$cast$whenComplete((CompletableFuture)t, arg_0, arg_1));
        return t;
    }

    private static /* synthetic */ void lambda$cast$whenComplete(CompletableFuture future, Object result, Throwable exception) {
        if (exception != null) {
            future.completeExceptionally(exception);
        } else {
            future.complete(result);
        }
    }

    public Task<Void> clearState(RemoteReference<?> reference, Object state) {
        StateWrapper wrapper = new StateWrapper(state);
        Task task = this.dynamoDBStorageExtension.readState(reference, (Object)wrapper);
        if (!task.toCompletableFuture().isDone()) {
            Task task2 = task;
            return DynamoS3StorageExtension.lambda$checkCast$cloud_orbit_concurrent_Task(task2.exceptionally(Function.identity()).thenCompose(arg_0 -> DynamoS3StorageExtension.async$clearState(this, reference, state, wrapper, task2, 1, arg_0)).toCompletableFuture());
        }
        Boolean readRecord = (Boolean)task.toCompletableFuture().join();
        if (readRecord.booleanValue()) {
            ArrayList<Task> tasks = new ArrayList<Task>();
            tasks.add(this.dynamoDBStorageExtension.clearState(reference, (Object)wrapper));
            if (wrapper.isS3Pointer) {
                tasks.add(this.s3StorageExtension.clearState(reference, state));
            }
            return Task.allOf(tasks);
        }
        return Task.done();
    }

    /*
     * Unable to fully structure code
     */
    private static CompletableFuture async$clearState(DynamoS3StorageExtension var0, RemoteReference var1_1, Object var2_2, StateWrapper var3_3, Task var4_4, int var5_5, Object var6_7) {
        switch (var5_5) {
            case 0: {
                wrapper = new StateWrapper(state);
                v0 = this.dynamoDBStorageExtension.readState((RemoteReference)reference, (Object)wrapper);
                if (!v0.toCompletableFuture().isDone()) {
                    var6_7 = v0;
                    return var6_7.exceptionally(Function.identity()).thenCompose((Function<Object, CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, async$clearState(cloud.orbit.actors.extensions.dynamos3.DynamoS3StorageExtension cloud.orbit.actors.runtime.RemoteReference java.lang.Object cloud.orbit.actors.extensions.dynamos3.DynamoS3StorageExtension$StateWrapper cloud.orbit.concurrent.Task int java.lang.Object ), (Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;)((DynamoS3StorageExtension)this, (RemoteReference)reference, (Object)state, (StateWrapper)wrapper, (Task)var6_7, (int)1)).toCompletableFuture();
                }
lbl8:
                // 3 sources

                while (true) {
                    readRecord = (Boolean)v0.toCompletableFuture().join();
                    if (readRecord.booleanValue()) {
                        tasks = new ArrayList<Task>();
                        tasks.add(this.dynamoDBStorageExtension.clearState((RemoteReference)reference, (Object)wrapper));
                        if (wrapper.isS3Pointer) {
                            tasks.add(this.s3StorageExtension.clearState((RemoteReference)reference, (Object)state));
                        }
                        return Task.allOf(tasks);
                    }
                    return Task.done();
                }
            }
            case 1: {
                v0 = var4_4;
                ** continue;
            }
        }
        throw new IllegalArgumentException();
    }

    public Task<Boolean> readState(RemoteReference<?> reference, Object state) {
        StateWrapper wrapper = new StateWrapper(state);
        Task task = this.dynamoDBStorageExtension.readState(reference, (Object)wrapper);
        if (!task.toCompletableFuture().isDone()) {
            Task task2 = task;
            return DynamoS3StorageExtension.lambda$checkCast$cloud_orbit_concurrent_Task(task2.exceptionally(Function.identity()).thenCompose(arg_0 -> DynamoS3StorageExtension.async$readState(this, reference, state, wrapper, task2, 1, arg_0)).toCompletableFuture());
        }
        Boolean readRecord = (Boolean)task.toCompletableFuture().join();
        if (readRecord.booleanValue()) {
            if (wrapper.isS3Pointer) {
                return this.s3StorageExtension.readState(reference, state);
            }
            try {
                this.mapper.readerForUpdating(state).readValue(this.mapper.writeValueAsString(wrapper.state));
            }
            catch (Exception e) {
                throw new UncheckedException((Throwable)e);
            }
        }
        return Task.fromValue((Object)readRecord);
    }

    /*
     * Unable to fully structure code
     */
    private static CompletableFuture async$readState(DynamoS3StorageExtension var0, RemoteReference var1_1, Object var2_2, StateWrapper var3_3, Task var4_4, int var5_5, Object var6_7) {
        switch (var5_5) {
            case 0: {
                wrapper = new StateWrapper(state);
                v0 = this.dynamoDBStorageExtension.readState((RemoteReference)reference, (Object)wrapper);
                if (!v0.toCompletableFuture().isDone()) {
                    var6_7 = v0;
                    return var6_7.exceptionally(Function.identity()).thenCompose((Function<Object, CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, async$readState(cloud.orbit.actors.extensions.dynamos3.DynamoS3StorageExtension cloud.orbit.actors.runtime.RemoteReference java.lang.Object cloud.orbit.actors.extensions.dynamos3.DynamoS3StorageExtension$StateWrapper cloud.orbit.concurrent.Task int java.lang.Object ), (Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;)((DynamoS3StorageExtension)this, (RemoteReference)reference, (Object)state, (StateWrapper)wrapper, (Task)var6_7, (int)1)).toCompletableFuture();
                }
lbl8:
                // 3 sources

                while (true) {
                    readRecord = (Boolean)v0.toCompletableFuture().join();
                    if (readRecord.booleanValue()) {
                        if (wrapper.isS3Pointer) {
                            return this.s3StorageExtension.readState((RemoteReference)reference, (Object)state);
                        }
                        try {
                            this.mapper.readerForUpdating((Object)state).readValue(this.mapper.writeValueAsString(wrapper.state));
                        }
                        catch (Exception e) {
                            throw new UncheckedException((Throwable)e);
                        }
                    }
                    return Task.fromValue((Object)readRecord);
                }
            }
            case 1: {
                v0 = var4_4;
                ** continue;
            }
        }
        throw new IllegalArgumentException();
    }

    public Task<Void> writeState(RemoteReference<?> reference, Object state) {
        StateWrapper wrapper = new StateWrapper(state);
        try {
            Task task = this.dynamoDBStorageExtension.writeState(reference, (Object)wrapper);
            if (!task.toCompletableFuture().isDone()) {
                Task task2 = task;
                return DynamoS3StorageExtension.lambda$checkCast$cloud_orbit_concurrent_Task(task2.exceptionally(Function.identity()).thenCompose(arg_0 -> DynamoS3StorageExtension.async$writeState(this, reference, state, wrapper, task2, 1, arg_0)).toCompletableFuture());
            }
            task.toCompletableFuture().join();
            return Task.done();
        }
        catch (CompletionException e) {
            AmazonServiceException ase;
            String errorCode;
            if (e.getCause() instanceof AmazonServiceException && !(errorCode = (ase = (AmazonServiceException)e.getCause()).getErrorCode()).equals("ValidationException")) {
                throw e;
            }
            wrapper.isS3Pointer = true;
            wrapper.state = null;
            Task s3Write = this.s3StorageExtension.writeState(reference, state);
            Task dynamoWrite = this.dynamoDBStorageExtension.writeState(reference, (Object)wrapper);
            return Task.allOf((CompletableFuture[])new CompletableFuture[]{s3Write, dynamoWrite});
        }
    }

    /*
     * Unable to fully structure code
     */
    private static CompletableFuture async$writeState(DynamoS3StorageExtension var0, RemoteReference var1_1, Object var2_2, StateWrapper var3_3, Task var4_4, int var5_7, Object var6_10) {
        switch (var5_7) {
            case 0: {
                wrapper = new StateWrapper(state);
                try {
                    v0 = this.dynamoDBStorageExtension.writeState((RemoteReference)reference, (Object)wrapper);
                    if (!v0.toCompletableFuture().isDone()) {
                        var7_11 = v0;
                        return var7_11.exceptionally(Function.identity()).thenCompose((Function<Object, CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, async$writeState(cloud.orbit.actors.extensions.dynamos3.DynamoS3StorageExtension cloud.orbit.actors.runtime.RemoteReference java.lang.Object cloud.orbit.actors.extensions.dynamos3.DynamoS3StorageExtension$StateWrapper cloud.orbit.concurrent.Task int java.lang.Object ), (Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;)((DynamoS3StorageExtension)this, (RemoteReference)reference, (Object)state, (StateWrapper)wrapper, (Task)var7_11, (int)1)).toCompletableFuture();
                    }
lbl9:
                    // 3 sources

                    while (true) {
                        v0.toCompletableFuture().join();
                        return Task.done();
                    }
                }
                catch (CompletionException e) {
                    if (e.getCause() instanceof AmazonServiceException && !(errorCode = (ase = (AmazonServiceException)e.getCause()).getErrorCode()).equals("ValidationException")) {
                        throw e;
                    }
                    wrapper.isS3Pointer = true;
                    wrapper.state = null;
                    s3Write = this.s3StorageExtension.writeState((RemoteReference)reference, (Object)state);
                    dynamoWrite = this.dynamoDBStorageExtension.writeState((RemoteReference)reference, (Object)wrapper);
                    return Task.allOf((CompletableFuture[])new CompletableFuture[]{s3Write, dynamoWrite});
                }
            }
            case 1: {
                v0 = var4_4;
                ** continue;
            }
        }
        throw new IllegalArgumentException();
    }

    public static class StateWrapper {
        public Object state;
        public boolean isS3Pointer;

        public StateWrapper() {
        }

        public StateWrapper(Object state) {
            this.state = state;
            this.isS3Pointer = false;
        }
    }
}

