/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.NamedPipelineExtension;
import cloud.orbit.actors.net.HandlerContext;
import cloud.orbit.actors.runtime.Message;
import cloud.orbit.concurrent.Task;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitMetricsMessagingExtension
extends NamedPipelineExtension {
    private static final Logger logger = LoggerFactory.getLogger(OrbitMetricsMessagingExtension.class);
    private static final String MESSAGING_METRICS_PIPELINE_NAME = "messaging-metrics-pipeline";
    private static final String MESSAGING_METRICS_UNTIMED = "orbit.messaging.untimed";
    private static final String MESSAGING_METRICS_HEADER_TIMESTAMP = "metrics-ts";
    private Map<Integer, Timer> inboundMetrics = new HashMap<Integer, Timer>();
    private Map<Integer, Meter> outboundMetrics = new HashMap<Integer, Meter>();
    private MetricRegistry metricRegistry;

    public OrbitMetricsMessagingExtension() {
        this(new MetricRegistry());
    }

    public OrbitMetricsMessagingExtension(MetricRegistry metricRegistry) {
        this(metricRegistry, MESSAGING_METRICS_PIPELINE_NAME, null, "messaging");
    }

    public OrbitMetricsMessagingExtension(String name, String beforeHandlerName, String afterHandlerName) {
        this(new MetricRegistry(), name, beforeHandlerName, afterHandlerName);
    }

    public OrbitMetricsMessagingExtension(MetricRegistry metricRegistry, String name, String beforeHandlerName, String afterHandlerName) {
        super(name, beforeHandlerName, afterHandlerName);
        this.metricRegistry = metricRegistry;
        this.setupMetrics();
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    private void setupMetrics() {
        this.inboundMetrics.put(0, this.metricRegistry.timer("orbit.messaging[type:one_way_message,direction:inbound]"));
        this.inboundMetrics.put(1, this.metricRegistry.timer("orbit.messaging[type:request_message,direction:inbound]"));
        this.inboundMetrics.put(3, this.metricRegistry.timer("orbit.messaging[type:response_error,direction:inbound]"));
        this.inboundMetrics.put(2, this.metricRegistry.timer("orbit.messaging[type:response_ok,direction:inbound]"));
        this.inboundMetrics.put(4, this.metricRegistry.timer("orbit.messaging[type:response_protocol_error,direction:inbound]"));
        this.outboundMetrics.put(0, this.metricRegistry.meter("orbit.messaging[type:one_way_message,direction:outbound]"));
        this.outboundMetrics.put(1, this.metricRegistry.meter("orbit.messaging[type:request_message,direction:outbound]"));
        this.outboundMetrics.put(3, this.metricRegistry.meter("orbit.messaging[type:response_error,direction:outbound]"));
        this.outboundMetrics.put(2, this.metricRegistry.meter("orbit.messaging[type:response_ok,direction:outbound]"));
        this.outboundMetrics.put(4, this.metricRegistry.meter("orbit.messaging[type:response_protocol_error,direction:outbound]"));
    }

    public void onRead(HandlerContext ctx, Object object) {
        long now = System.currentTimeMillis();
        if (object instanceof Message) {
            Message message = (Message)object;
            Long messageCreationTimestamp = (Long)message.getHeader(MESSAGING_METRICS_HEADER_TIMESTAMP);
            if (messageCreationTimestamp != null) {
                Timer metric = this.inboundMetrics.get(message.getMessageType());
                if (metric != null) {
                    metric.update(now - messageCreationTimestamp, TimeUnit.MILLISECONDS);
                }
            } else {
                this.metricRegistry.meter("orbit.messaging.untimed[direction:inbound]").mark();
            }
        }
        ctx.fireRead(object);
    }

    public Task<?> write(HandlerContext ctx, Object object) throws Exception {
        if (object instanceof Message) {
            Message message = (Message)object;
            Meter metric = this.outboundMetrics.get(message.getMessageType());
            if (metric != null) {
                metric.mark();
            }
            message.setHeader(MESSAGING_METRICS_HEADER_TIMESTAMP, (Object)System.currentTimeMillis());
        }
        return ctx.write(object);
    }
}

