/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.runtime.DefaultInvocationHandler;
import cloud.orbit.actors.runtime.Invocation;
import cloud.orbit.actors.runtime.RemoteReference;
import com.codahale.metrics.MetricRegistry;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class OrbitMetricsInvocationHandler
extends DefaultInvocationHandler {
    private MetricRegistry metricRegistry;

    public OrbitMetricsInvocationHandler() {
        this(new MetricRegistry());
    }

    public OrbitMetricsInvocationHandler(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public void afterInvoke(long startTimeNanos, Invocation invocation, Method method) {
        RemoteReference toReference = invocation.getToReference();
        super.afterInvoke(startTimeNanos, invocation, method);
        long durationNanos = System.nanoTime() - startTimeNanos;
        Class actorClass = RemoteReference.getInterfaceClass((RemoteReference)toReference);
        String metricsKey = OrbitMetricsInvocationHandler.getActorMethodResponseTimeMetricsKey(actorClass, method.getName());
        this.metricRegistry.timer(metricsKey).update(durationNanos, TimeUnit.NANOSECONDS);
    }

    public void taskComplete(long startTimeNanos, Invocation invocation, Method method) {
        RemoteReference toReference = invocation.getToReference();
        super.afterInvoke(startTimeNanos, invocation, method);
        long durationNanos = System.nanoTime() - startTimeNanos;
        Class actorClass = RemoteReference.getInterfaceClass((RemoteReference)toReference);
        String metricsKey = OrbitMetricsInvocationHandler.getActorChainResponseTimeMetricsKey(actorClass, method.getName());
        this.metricRegistry.timer(metricsKey).update(durationNanos, TimeUnit.NANOSECONDS);
    }

    public static String getActorMethodResponseTimeMetricsKey(Class<?> actorClass, String methodName) {
        return String.format("orbit.actors.methodresponsetime[actor:%s,method:%s]", actorClass.getSimpleName(), methodName);
    }

    public static String getActorChainResponseTimeMetricsKey(Class<?> actorClass, String methodName) {
        return String.format("orbit.actors.chainresponsetime[actor:%s,method:%s]", actorClass.getSimpleName(), methodName);
    }
}

