/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.MessageSerializer;
import cloud.orbit.actors.runtime.BasicRuntime;
import cloud.orbit.actors.runtime.Message;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class InstrumentedMessageSerializer
implements MessageSerializer {
    private final MetricRegistry metricRegistry;
    private final MessageSerializer messageSerializer;
    private Map<Integer, Histogram> serializeMetrics;

    public InstrumentedMessageSerializer(MessageSerializer messageSerializer) {
        this(new MetricRegistry(), messageSerializer);
    }

    public InstrumentedMessageSerializer(MetricRegistry metricRegistry, MessageSerializer messageSerializer) {
        this.metricRegistry = metricRegistry;
        this.messageSerializer = messageSerializer;
        this.setupMetrics();
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    private void setupMetrics() {
        String metricName = "orbit.messaging.size_in_bytes";
        this.serializeMetrics.put(0, this.metricRegistry.histogram(metricName + "[type:one_way_message]"));
        this.serializeMetrics.put(1, this.metricRegistry.histogram(metricName + "[type:request_message]"));
        this.serializeMetrics.put(3, this.metricRegistry.histogram(metricName + "[type:response_error]"));
        this.serializeMetrics.put(2, this.metricRegistry.histogram(metricName + "[type:response_ok]"));
        this.serializeMetrics.put(4, this.metricRegistry.histogram(metricName + "[type:response_protocol_error]"));
    }

    public Message deserializeMessage(BasicRuntime runtime, InputStream inputStream) throws Exception {
        return this.messageSerializer.deserializeMessage(runtime, inputStream);
    }

    public void serializeMessage(BasicRuntime runtime, OutputStream out, Message message) throws Exception {
        this.messageSerializer.serializeMessage(runtime, out, message);
        Histogram serializeHistogram = this.serializeMetrics.get(message.getMessageType());
        if (serializeHistogram == null) {
            return;
        }
        if (out instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream outByteArray = (ByteArrayOutputStream)out;
            serializeHistogram.update(outByteArray.size());
        }
    }
}

