/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.Actor;
import cloud.orbit.actors.extensions.LifetimeExtension;
import cloud.orbit.actors.extensions.NamedPipelineExtension;
import cloud.orbit.actors.net.HandlerContext;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.actors.runtime.Invocation;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.concurrent.Task;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitMetricsActorExtension
extends NamedPipelineExtension
implements LifetimeExtension {
    private static final Logger logger = LoggerFactory.getLogger(OrbitMetricsActorExtension.class);
    public static final String ACTOR_METRICS_PIPELINE_NAME = "actor-metrics-pipeline";
    private Map<String, Timer.Context> actorActivationTimers = new ConcurrentHashMap<String, Timer.Context>();
    private Map<String, Timer.Context> actorLifetimeTimers = new ConcurrentHashMap<String, Timer.Context>();
    private Map<String, Timer.Context> actorDeactivationTimers = new ConcurrentHashMap<String, Timer.Context>();
    private MetricRegistry metricRegistry;

    public OrbitMetricsActorExtension() {
        this(new MetricRegistry());
    }

    public OrbitMetricsActorExtension(MetricRegistry metricRegistry) {
        this(metricRegistry, ACTOR_METRICS_PIPELINE_NAME, null, "execution");
    }

    public OrbitMetricsActorExtension(String name, String beforeHandlerName, String afterHandlerName) {
        this(new MetricRegistry(), name, beforeHandlerName, afterHandlerName);
    }

    public OrbitMetricsActorExtension(MetricRegistry metricRegistry, String name, String beforeHandlerName, String afterHandlerName) {
        super(name, beforeHandlerName, afterHandlerName);
        this.metricRegistry = metricRegistry;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void onRead(HandlerContext ctx, Object message) {
        if (message instanceof Invocation) {
            Invocation invocation = (Invocation)message;
            RemoteReference toReference = invocation.getToReference();
            Class toClass = RemoteReference.getInterfaceClass((RemoteReference)toReference);
            this.metricRegistry.meter(OrbitMetricsActorExtension.getActorTypeMessageReceiveRateMetricsKey(toClass)).mark();
        }
        ctx.fireRead(message);
    }

    public Task<?> preActivation(AbstractActor<?> actor) {
        String actorTypeActivationMetricsKey = OrbitMetricsActorExtension.getActorTypeActivationMetricsKey(RemoteReference.getInterfaceClass(actor));
        Timer.Context timer = this.metricRegistry.timer(actorTypeActivationMetricsKey).time();
        String actorActivationTimerKey = OrbitMetricsActorExtension.getActorTimerKey(actor);
        this.actorActivationTimers.put(actorActivationTimerKey, timer);
        return Task.done();
    }

    public Task<?> postActivation(AbstractActor<?> actor) {
        Timer.Context actorActivationTimer = this.actorActivationTimers.remove(OrbitMetricsActorExtension.getActorTimerKey(actor));
        if (null != actorActivationTimer) {
            actorActivationTimer.stop();
        }
        String actorCounterKey = OrbitMetricsActorExtension.getActorTypeCounterMetricsKey(RemoteReference.getInterfaceClass(actor));
        this.metricRegistry.counter(actorCounterKey).inc();
        String actorTypeLifetimeMetricsKey = OrbitMetricsActorExtension.getActorTypeLifetimeMetricsKey(RemoteReference.getInterfaceClass(actor));
        Timer.Context timer = this.metricRegistry.timer(actorTypeLifetimeMetricsKey).time();
        String actorLifetimeTimerKey = OrbitMetricsActorExtension.getActorTimerKey(actor);
        this.actorLifetimeTimers.put(actorLifetimeTimerKey, timer);
        return Task.done();
    }

    public Task<?> preDeactivation(AbstractActor<?> actor) {
        Timer.Context lifetimeTimer = this.actorLifetimeTimers.remove(OrbitMetricsActorExtension.getActorTimerKey(actor));
        if (null != lifetimeTimer) {
            lifetimeTimer.stop();
        }
        String actorCounterKey = OrbitMetricsActorExtension.getActorTypeCounterMetricsKey(RemoteReference.getInterfaceClass(actor));
        this.metricRegistry.counter(actorCounterKey).dec();
        String actorDeactivationMetricsKey = OrbitMetricsActorExtension.getActorTypeDeactivationMetricsKey(RemoteReference.getInterfaceClass(actor));
        Timer.Context timer = this.metricRegistry.timer(actorDeactivationMetricsKey).time();
        String actorDeactivationTimerKey = OrbitMetricsActorExtension.getActorTimerKey(actor);
        this.actorDeactivationTimers.put(actorDeactivationTimerKey, timer);
        return Task.done();
    }

    public Task<?> postDeactivation(AbstractActor<?> actor) {
        Timer.Context deactivationTimer = this.actorDeactivationTimers.remove(OrbitMetricsActorExtension.getActorTimerKey(actor));
        if (null != deactivationTimer) {
            deactivationTimer.stop();
        }
        return Task.done();
    }

    public static String getActorTimerKey(AbstractActor<?> actor) {
        Object id = RemoteReference.getId(actor);
        return String.format("actors.%s.%s.timer", RemoteReference.getInterfaceClass(actor).getSimpleName(), id);
    }

    public static String getActorTypeMessageReceiveRateMetricsKey(Class<? extends Actor> actorClass) {
        return String.format("orbit.actors.msg_received_rate[actor:%s]", actorClass.getSimpleName());
    }

    public static String getActorTypeCounterMetricsKey(Class<? extends Actor> actorClass) {
        return String.format("orbit.actors.count[actor:%s]", actorClass.getSimpleName());
    }

    public static String getActorTypeLifetimeMetricsKey(Class<? extends Actor> actorClass) {
        return String.format("orbit.actors.lifetime[actor:%s]", actorClass.getSimpleName());
    }

    public static String getActorTypeActivationMetricsKey(Class<? extends Actor> actorClass) {
        return String.format("orbit.actors.activation_time[actor:%s]", actorClass.getSimpleName());
    }

    public static String getActorTypeDeactivationMetricsKey(Class<? extends Actor> actorClass) {
        return String.format("orbit.actors.deactivation_time[actor:%s]", actorClass.getSimpleName());
    }
}

