/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.NamedPipelineExtension;
import cloud.orbit.actors.extensions.metrics.dropwizard.MetricsManager;
import cloud.orbit.actors.net.HandlerContext;
import cloud.orbit.actors.runtime.Message;
import cloud.orbit.concurrent.Task;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitMessagingMetricsExtension
extends NamedPipelineExtension {
    private static final Logger logger = LoggerFactory.getLogger(OrbitMessagingMetricsExtension.class);
    public static final String MESSAGING_METRICS_PIPELINE_NAME = "messaging-metrics-pipeline";
    private static final String MESSAGING_METRICS_HEADER_TIMESTAMP = "metrics-ts";
    private Map<Integer, Timer> inboundMetrics = new HashMap<Integer, Timer>();
    private Map<Integer, Meter> outboundMetrics = new HashMap<Integer, Meter>();

    public OrbitMessagingMetricsExtension() {
        this(MESSAGING_METRICS_PIPELINE_NAME, null, "messaging");
    }

    public OrbitMessagingMetricsExtension(String name, String beforeHandlerName, String afterHandlerName) {
        super(name, beforeHandlerName, afterHandlerName);
        this.setupMetrics();
    }

    private void setupMetrics() {
        this.inboundMetrics.put(0, MetricsManager.getInstance().getRegistry().timer("orbit.messaging[type:one_way_message,direction:inbound]"));
        this.inboundMetrics.put(1, MetricsManager.getInstance().getRegistry().timer("orbit.messaging[type:request_message,direction:inbound]"));
        this.inboundMetrics.put(3, MetricsManager.getInstance().getRegistry().timer("orbit.messaging[type:response_error,direction:inbound]"));
        this.inboundMetrics.put(2, MetricsManager.getInstance().getRegistry().timer("orbit.messaging[type:response_ok,direction:inbound]"));
        this.inboundMetrics.put(4, MetricsManager.getInstance().getRegistry().timer("orbit.messaging[type:response_protocol_error,direction:inbound]"));
        this.outboundMetrics.put(0, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:one_way_message,direction:outbound]"));
        this.outboundMetrics.put(1, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:request_message,direction:outbound]"));
        this.outboundMetrics.put(3, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:response_error,direction:outbound]"));
        this.outboundMetrics.put(2, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:response_ok,direction:outbound]"));
        this.outboundMetrics.put(4, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:response_protocol_error,direction:outbound]"));
    }

    public void onRead(HandlerContext ctx, Object object) {
        long now = System.currentTimeMillis();
        if (object instanceof Message) {
            Message message = (Message)object;
            Long messageCreationTimestamp = (Long)message.getHeader((Object)MESSAGING_METRICS_HEADER_TIMESTAMP);
            Timer metric = this.inboundMetrics.get(message.getMessageType());
            if (metric != null && messageCreationTimestamp != null) {
                metric.update(now - messageCreationTimestamp, TimeUnit.MILLISECONDS);
            }
        }
        ctx.fireRead(object);
    }

    public Task<?> write(HandlerContext ctx, Object object) throws Exception {
        if (object instanceof Message) {
            Message message = (Message)object;
            Meter metric = this.outboundMetrics.get(message.getMessageType());
            if (metric != null) {
                metric.mark();
            }
            message.setHeader((Object)MESSAGING_METRICS_HEADER_TIMESTAMP, (Object)System.currentTimeMillis());
        }
        return ctx.write(object);
    }
}

