/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.Actor;
import cloud.orbit.actors.extensions.LifetimeExtension;
import cloud.orbit.actors.extensions.NamedPipelineExtension;
import cloud.orbit.actors.extensions.metrics.dropwizard.MetricsManager;
import cloud.orbit.actors.net.HandlerContext;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.actors.runtime.Invocation;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.concurrent.Task;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitActorExtension
extends NamedPipelineExtension
implements LifetimeExtension {
    private static final Logger logger = LoggerFactory.getLogger(OrbitActorExtension.class);
    public static final String ACTOR_METRICS_PIPELINE_NAME = "actor-metrics-pipeline";
    Map<String, Timer.Context> actorActivationTimers = new ConcurrentHashMap<String, Timer.Context>();
    Map<String, Timer.Context> actorLifeSpanTimers = new ConcurrentHashMap<String, Timer.Context>();
    Map<String, Timer.Context> actorDeactivationTimers = new ConcurrentHashMap<String, Timer.Context>();

    public OrbitActorExtension() {
        super(ACTOR_METRICS_PIPELINE_NAME, null, "execution");
    }

    public OrbitActorExtension(String name, String beforeHandlerName, String afterHandlerName) {
        super(name, beforeHandlerName, afterHandlerName);
    }

    public void onRead(HandlerContext ctx, Object message) {
        if (message instanceof Invocation) {
            Invocation invocation = (Invocation)message;
            RemoteReference toReference = invocation.getToReference();
            Class toClass = RemoteReference.getInterfaceClass((RemoteReference)toReference);
            MetricsManager.getInstance().getRegistry().meter(OrbitActorExtension.getActorTypeMessageReceiveRateMetricsKey(toClass)).mark();
        }
        ctx.fireRead(message);
    }

    public Task<?> preActivation(AbstractActor<?> actor) {
        String actorTypeActivationTimerKey = OrbitActorExtension.getActorTypeActivationMetricsKey(RemoteReference.getInterfaceClass(actor));
        Timer.Context timer = MetricsManager.getInstance().getRegistry().timer(actorTypeActivationTimerKey).time();
        String activationTimerKey = OrbitActorExtension.getActorTimerKey(actor);
        this.actorActivationTimers.put(activationTimerKey, timer);
        return Task.done();
    }

    public Task<?> postActivation(AbstractActor<?> actor) {
        String actorCounterKey = OrbitActorExtension.getActorTypeCounterMetricsKey(RemoteReference.getInterfaceClass(actor));
        MetricsManager.getInstance().getRegistry().counter(actorCounterKey).inc();
        Timer.Context actorActivationTimer = this.actorActivationTimers.remove(OrbitActorExtension.getActorTimerKey(actor));
        if (null != actorActivationTimer) {
            actorActivationTimer.stop();
        }
        String actorLifespanTimerKey = OrbitActorExtension.getActorTimerKey(actor);
        String actorTypeLifespanMetricsKey = OrbitActorExtension.getActorTypeLifeSpanMetricsKey(RemoteReference.getInterfaceClass(actor));
        Timer.Context timer = MetricsManager.getInstance().getRegistry().timer(actorTypeLifespanMetricsKey).time();
        this.actorLifeSpanTimers.put(actorLifespanTimerKey, timer);
        return Task.done();
    }

    public Task<?> preDeactivation(AbstractActor<?> actor) {
        String actorCounterKey = OrbitActorExtension.getActorTypeCounterMetricsKey(RemoteReference.getInterfaceClass(actor));
        MetricsManager.getInstance().getRegistry().counter(actorCounterKey).dec();
        String actorDeactivationTimerKey = OrbitActorExtension.getActorTimerKey(actor);
        String actorDeactivationMetricsKey = OrbitActorExtension.getActorTypeDeactivationMetricsKey(RemoteReference.getInterfaceClass(actor));
        Timer.Context timer = MetricsManager.getInstance().getRegistry().timer(actorDeactivationMetricsKey).time();
        this.actorDeactivationTimers.put(actorDeactivationTimerKey, timer);
        String actorLifespanTimerKey = OrbitActorExtension.getActorTimerKey(actor);
        String actorTypeLifespanMetricsKey = OrbitActorExtension.getActorTypeLifeSpanMetricsKey(RemoteReference.getInterfaceClass(actor));
        Timer.Context lifespanTimer = this.actorLifeSpanTimers.remove(actorLifespanTimerKey);
        if (null != lifespanTimer) {
            lifespanTimer.stop();
        }
        return Task.done();
    }

    public Task<?> postDeactivation(AbstractActor<?> actor) {
        String actorDeactivationTimerKey = OrbitActorExtension.getActorTimerKey(actor);
        Timer.Context deactivationTimer = this.actorDeactivationTimers.remove(actorDeactivationTimerKey);
        if (null != deactivationTimer) {
            deactivationTimer.stop();
        }
        return Task.done();
    }

    public static String getActorTimerKey(AbstractActor<?> actor) {
        Object id = RemoteReference.getId(actor);
        return String.format("actors.%s.%s.timer", RemoteReference.getInterfaceClass(actor).getSimpleName(), id);
    }

    public static String getActorTypeMessageReceiveRateMetricsKey(Class<? extends Actor> actorClass) {
        return String.format("orbit.actors.msg_received_rate[[actor:%s]]", actorClass.getSimpleName());
    }

    public static String getActorTypeCounterMetricsKey(Class<? extends Actor> actorClass) {
        return String.format("orbit.actors.count[actor:%s]", actorClass.getSimpleName());
    }

    public static String getActorTypeLifeSpanMetricsKey(Class<? extends Actor> actorClass) {
        return String.format("orbit.actors.lifespan[actor:%s]", actorClass.getSimpleName());
    }

    public static String getActorTypeActivationMetricsKey(Class<? extends Actor> actorClass) {
        return String.format("orbit.actors.activation_time[actor:%s]", actorClass.getSimpleName());
    }

    public static String getActorTypeDeactivationMetricsKey(Class<? extends Actor> actorClass) {
        return String.format("orbit.actors.deactivation_time[actor:%s]", actorClass.getSimpleName());
    }
}

