/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.metrics.dropwizard.ReporterConfig;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsManager {
    private static final Logger logger = LoggerFactory.getLogger(MetricsManager.class);
    private static MetricsManager instance = new MetricsManager();
    private MetricRegistry registry = new MetricRegistry();
    private boolean isInitialized = false;

    private MetricsManager() {
    }

    public static MetricsManager getInstance() {
        return instance;
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public synchronized void initializeMetrics(List<ReporterConfig> reporterConfigs) {
        if (this.isInitialized) {
            logger.warn("Attempting to initialize the Metrics Manager when it is already initialized!");
            return;
        }
        for (ReporterConfig reporterConfig : reporterConfigs) {
            Reporter reporter = reporterConfig.enableReporter(this.registry);
            if (reporter != null) continue;
            logger.warn("Failed to enable reporter " + reporterConfig.getClass().getName());
        }
        this.isInitialized = true;
        logger.info("Orbit Metrics Initialized.");
    }

    public void registerMetric(String name, Metric metric) {
        try {
            this.registry.register(name, metric);
            logger.debug("Registered new metric {}", (Object)name);
        }
        catch (IllegalArgumentException iae) {
            logger.warn("Unable to register metric {} because a metric already has been registered with the same name", (Object)name);
        }
    }

    public void unregisterMetric(String name) {
        this.registry.remove(name);
    }

    public void setRegistry(MetricRegistry registry) {
        this.registry = registry;
        this.isInitialized = false;
    }
}

