/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.metrics.dropwizard.ReporterConfig;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.coursera.metrics.datadog.DatadogReporter;
import org.coursera.metrics.datadog.transport.HttpTransport;
import org.coursera.metrics.datadog.transport.Transport;
import org.coursera.metrics.datadog.transport.UdpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogReporterConfig
extends ReporterConfig {
    private static final Logger logger = LoggerFactory.getLogger(DatadogReporterConfig.class);
    private String apiKey;
    private String statsdHost;
    private int statsdPort;
    private String mode;

    public synchronized ScheduledReporter enableReporter(MetricRegistry registry) {
        HttpTransport transport = null;
        if ("http".equalsIgnoreCase(this.mode)) {
            transport = new HttpTransport.Builder().withApiKey(this.apiKey).build();
        } else if ("udp".equalsIgnoreCase(this.mode)) {
            transport = new UdpTransport.Builder().withStatsdHost(this.statsdHost).withPort(this.statsdPort).build();
        } else {
            logger.error("Invalid mode for Datadog reporter.");
        }
        DatadogReporter datadogReporter = null;
        try {
            datadogReporter = DatadogReporter.forRegistry((MetricRegistry)registry).convertRatesTo(this.getRateTimeUnit()).convertDurationsTo(this.getDurationTimeUnit()).withHost(InetAddress.getLocalHost().getCanonicalHostName()).withPrefix(this.getPrefix()).withTransport((Transport)transport).build();
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage());
        }
        datadogReporter.start((long)this.getPeriod(), this.getPeriodTimeUnit());
        return datadogReporter;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setStatsdHost(String statsdHost) {
        this.statsdHost = statsdHost;
    }

    public void setStatsdPort(int statsdPort) {
        this.statsdPort = statsdPort;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getStatsdHost() {
        return this.statsdHost;
    }

    public int getStatsdPort() {
        return this.statsdPort;
    }

    public String getMode() {
        return this.mode;
    }
}

