/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.metrics.dropwizard.MetricsManager;
import cloud.orbit.actors.runtime.DefaultInvocationHandler;
import cloud.orbit.actors.runtime.Invocation;
import cloud.orbit.actors.runtime.RemoteReference;
import com.codahale.metrics.Histogram;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OrbitMetricsInvocationHandler
extends DefaultInvocationHandler {
    private Map<String, Histogram> actorMethodResponseTimeHistograms = new ConcurrentHashMap<String, Histogram>();
    private Map<String, Histogram> actorChainResponseTimeHistograms = new ConcurrentHashMap<String, Histogram>();

    public void afterInvoke(long startTimeNanos, Invocation invocation, Method method) {
        RemoteReference toReference = invocation.getToReference();
        super.afterInvoke(startTimeNanos, invocation, method);
        long durationNanos = System.nanoTime() - startTimeNanos;
        Double durationMs = (double)durationNanos / 1000000.0;
        Class actorClass = RemoteReference.getInterfaceClass((RemoteReference)toReference);
        String histKey = OrbitMetricsInvocationHandler.getActorMethodResponseTimeMetricKey(actorClass, method.getName());
        Histogram hist = this.actorMethodResponseTimeHistograms.get(histKey);
        if (null == hist) {
            hist = MetricsManager.getInstance().getRegistry().histogram(histKey);
            this.actorMethodResponseTimeHistograms.put(histKey, hist);
        }
        hist.update(durationMs.intValue());
    }

    public void taskComplete(long startTimeNanos, Invocation invocation, Method method) {
        RemoteReference toReference = invocation.getToReference();
        super.afterInvoke(startTimeNanos, invocation, method);
        long durationNanos = System.nanoTime() - startTimeNanos;
        Double durationMs = (double)durationNanos / 1000000.0;
        Class actorClass = RemoteReference.getInterfaceClass((RemoteReference)toReference);
        String histKey = OrbitMetricsInvocationHandler.getActorChainResponseTimeMetricKey(actorClass, method.getName());
        Histogram hist = this.actorChainResponseTimeHistograms.get(histKey);
        if (null == hist) {
            hist = MetricsManager.getInstance().getRegistry().histogram(histKey);
            this.actorChainResponseTimeHistograms.put(histKey, hist);
        }
        hist.update(durationMs.intValue());
    }

    public static String getActorMethodResponseTimeMetricKey(Class actorClass, String methodName) {
        return String.format("orbit.actors.methodresponsetimehistogram[actor:%s,method:%s]", actorClass.getSimpleName(), methodName);
    }

    public static String getActorChainResponseTimeMetricKey(Class actorClass, String methodName) {
        return String.format("orbit.actors.chainresponsetimehistogram[actor:%s,method:%s]", actorClass.getSimpleName(), methodName);
    }
}

