/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.metrics.dropwizard.ReporterConfig;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsManager {
    private static MetricsManager instance = new MetricsManager();
    private MetricRegistry registry;
    private Map<ReporterConfig, Reporter> reporters = new HashMap<ReporterConfig, Reporter>();
    private static final Logger logger = LoggerFactory.getLogger(MetricsManager.class);
    private boolean isInitialized = false;

    public static MetricsManager getInstance() {
        return instance;
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public synchronized void initializeMetrics(List<ReporterConfig> reporterConfigs) {
        if (!this.isInitialized) {
            for (ReporterConfig reporterConfig : reporterConfigs) {
                Reporter reporter = reporterConfig.enableReporter(this.registry);
                if (reporter != null) {
                    this.reporters.put(reporterConfig, reporter);
                    continue;
                }
                logger.warn("Failed to enable reporter " + reporterConfig.getClass().getName());
            }
            this.isInitialized = true;
            logger.info("Orbit Metrics Initialized.");
        } else if (logger.isWarnEnabled()) {
            logger.warn("Attempting to initialize the Metrics Manager when it is already initialized!");
        }
    }

    public void registerMetric(String name, Metric metric) {
        try {
            this.registry.register(name, metric);
            if (logger.isDebugEnabled()) {
                logger.debug("Registered new metric " + name);
            }
        }
        catch (IllegalArgumentException iae) {
            logger.warn("Unable to register metric " + name + " because a metric already has been registered with the same name");
        }
    }

    public void unregisterMetric(String name) {
        this.registry.remove(name);
    }

    public void setRegistry(MetricRegistry registry) {
        this.registry = registry;
        this.isInitialized = false;
    }
}

