/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.metrics.dropwizard.ReporterConfig;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.ganglia.GangliaReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaReporterConfig
extends ReporterConfig {
    private static final Logger logger = LoggerFactory.getLogger(GangliaReporterConfig.class);
    private String host;
    private int port;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public synchronized ScheduledReporter enableReporter(MetricRegistry registry) {
        try {
            GMetric ganglia = new GMetric(this.host, this.port, GMetric.UDPAddressingMode.MULTICAST, 1);
            GangliaReporter reporter = GangliaReporter.forRegistry((MetricRegistry)registry).convertRatesTo(this.getRateTimeUnit()).convertDurationsTo(this.getDurationTimeUnit()).prefixedWith(this.getPrefix()).build(ganglia);
            reporter.start((long)this.getPeriod(), this.getPeriodTimeUnit());
            return reporter;
        }
        catch (IOException iex) {
            logger.warn("Unable to enable Ganglia Reporter: " + iex.getMessage());
            return null;
        }
    }
}

