/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.NamedPipelineExtension;
import cloud.orbit.actors.extensions.metrics.dropwizard.MetricsManager;
import cloud.orbit.actors.net.HandlerContext;
import cloud.orbit.actors.runtime.Message;
import cloud.orbit.concurrent.Task;
import com.codahale.metrics.Meter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitMessagingMetricsExtension
extends NamedPipelineExtension {
    public static final String MESSAGING_METRICS_PIPELINE_NAME = "messaging-metrics-pipeline";
    private Logger logger = LoggerFactory.getLogger(OrbitMessagingMetricsExtension.class);
    private Map<Integer, Meter> receiveMeters = new HashMap<Integer, Meter>();
    private Map<Integer, Meter> sendMeters = new HashMap<Integer, Meter>();

    public OrbitMessagingMetricsExtension() {
        super(MESSAGING_METRICS_PIPELINE_NAME, null, "messaging");
        this.setupMetrics();
    }

    public OrbitMessagingMetricsExtension(String name, String beforeHandlerName, String afterHandlerName) {
        super(name, beforeHandlerName, afterHandlerName);
        this.setupMetrics();
    }

    private void setupMetrics() {
        this.receiveMeters.put(0, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:one_way_message,direction:inbound]"));
        this.receiveMeters.put(1, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:request_message,direction:inbound]"));
        this.receiveMeters.put(3, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:response_error,direction:inbound]"));
        this.receiveMeters.put(2, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:response_ok,direction:inbound]"));
        this.receiveMeters.put(4, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:response_protocol_error,direction:inbound]"));
        this.sendMeters.put(0, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:one_way_message,direction:outbound]"));
        this.sendMeters.put(1, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:request_message,direction:outbound]"));
        this.sendMeters.put(3, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:response_error,direction:outbound]"));
        this.sendMeters.put(2, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:response_ok,direction:outbound]"));
        this.sendMeters.put(4, MetricsManager.getInstance().getRegistry().meter("orbit.messaging[type:response_protocol_error,direction:outbound]"));
    }

    public void onRead(HandlerContext ctx, Object message) {
        Meter meter;
        if (message instanceof Message && null != (meter = this.receiveMeters.get(((Message)message).getMessageType()))) {
            meter.mark();
        }
        ctx.fireRead(message);
    }

    public Task write(HandlerContext ctx, Object message) throws Exception {
        Meter meter;
        if (message instanceof Message && null != (meter = this.sendMeters.get(((Message)message).getMessageType()))) {
            meter.mark();
        }
        return ctx.write(message);
    }
}

