/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.ActorExtension;
import cloud.orbit.actors.extensions.metrics.dropwizard.MetricsManager;
import cloud.orbit.actors.extensions.metrics.dropwizard.ReporterConfig;
import cloud.orbit.concurrent.Task;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;

public class MetricsExtension
implements ActorExtension {
    private List<ReporterConfig> metricsConfig = new ArrayList<ReporterConfig>();

    public MetricsExtension(MetricRegistry metricRegistry) {
        if (metricRegistry == null) {
            throw new IllegalArgumentException("metricRegistry cannot be null");
        }
        MetricsManager.getInstance().setRegistry(metricRegistry);
    }

    public MetricsExtension() {
        MetricsManager.getInstance().setRegistry(new MetricRegistry());
    }

    public MetricsExtension(List<ReporterConfig> metricsConfigs) {
        if (metricsConfigs == null) {
            throw new IllegalArgumentException("metricsConfigs cannot be null");
        }
        this.metricsConfig.addAll(metricsConfigs);
        MetricsManager.getInstance().setRegistry(new MetricRegistry());
    }

    public Task<?> start() {
        MetricsManager.getInstance().initializeMetrics(this.metricsConfig);
        return Task.done();
    }

    public Task<?> stop() {
        return Task.done();
    }
}

