/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.metrics.dropwizard.MetricsManager;
import cloud.orbit.actors.runtime.Invocation;
import cloud.orbit.actors.runtime.InvocationHandler;
import cloud.orbit.actors.runtime.RemoteReference;
import com.codahale.metrics.Histogram;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OrbitMetricsInvocationHandler
extends InvocationHandler {
    private Map<String, Histogram> actorResponseTimeHistograms = new ConcurrentHashMap<String, Histogram>();

    public void afterInvoke(long startTimeMs, Invocation invocation, Method method) {
        RemoteReference toReference = invocation.getToReference();
        super.afterInvoke(startTimeMs, invocation, method);
        long durationNanos = System.nanoTime() - startTimeMs;
        Class actorClass = RemoteReference.getInterfaceClass((RemoteReference)toReference);
        Histogram hist = this.actorResponseTimeHistograms.get(actorClass.getSimpleName());
        if (null == hist) {
            hist = MetricsManager.getInstance().getRegistry().histogram(OrbitMetricsInvocationHandler.getActorResponseTimeMetricKey(actorClass));
            this.actorResponseTimeHistograms.put(actorClass.getSimpleName(), hist);
        }
        hist.update(durationNanos);
    }

    public static String getActorResponseTimeMetricKey(Class actorClass) {
        return String.format("orbit.actors.responsetimehistogram[actor:%s]", actorClass.getSimpleName());
    }
}

