/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.LifetimeExtension;
import cloud.orbit.actors.extensions.NamedPipelineExtension;
import cloud.orbit.actors.extensions.metrics.dropwizard.MetricsManager;
import cloud.orbit.actors.net.HandlerContext;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.actors.runtime.Invocation;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.concurrent.Task;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitActorExtension
extends NamedPipelineExtension
implements LifetimeExtension {
    public static final String ACTOR_METRICS_PIPELINE_NAME = "actor-metrics-pipeline";
    private Logger logger = LoggerFactory.getLogger(OrbitActorExtension.class);
    Map<String, Counter> actorCounters = new HashMap<String, Counter>();
    Map<String, Long> actorStartTimes = new ConcurrentHashMap<String, Long>();
    Map<String, Histogram> actorLifeSpanHistograms = new HashMap<String, Histogram>();
    Map<String, Meter> actorMsgReceivedRate = new HashMap<String, Meter>();

    public OrbitActorExtension() {
        super(ACTOR_METRICS_PIPELINE_NAME, null, "execution");
    }

    public OrbitActorExtension(String name, String beforeHandlerName, String afterHandlerName) {
        super(name, beforeHandlerName, afterHandlerName);
    }

    public void onRead(HandlerContext ctx, Object message) {
        if (message instanceof Invocation) {
            Invocation invocation = (Invocation)message;
            RemoteReference toReference = invocation.getToReference();
            Class toClass = RemoteReference.getInterfaceClass((RemoteReference)toReference);
            Object toId = RemoteReference.getId((RemoteReference)toReference);
            Meter msgReceivedMeter = this.actorMsgReceivedRate.get(toClass.getSimpleName());
            if (null == msgReceivedMeter) {
                msgReceivedMeter = MetricsManager.getInstance().getRegistry().meter(OrbitActorExtension.getActorMessageReceiveRateMetricKey(toClass));
                this.actorMsgReceivedRate.put(toClass.getSimpleName(), msgReceivedMeter);
            }
            msgReceivedMeter.mark();
        }
        ctx.fireRead(message);
    }

    public Task write(HandlerContext ctx, Object message) throws Exception {
        if (message instanceof Invocation) {
            Class clazz = RemoteReference.getInterfaceClass((RemoteReference)((Invocation)message).getToReference());
        }
        return ctx.write(message);
    }

    public Task<?> postActivation(AbstractActor<?> actor) {
        Object id = RemoteReference.getId(actor);
        String actorCounterKey = OrbitActorExtension.getActorCounterMetricsKey(actor.getClass());
        Counter counter = MetricsManager.getInstance().getRegistry().counter(actorCounterKey);
        if (null == counter) {
            counter = MetricsManager.getInstance().getRegistry().counter(actorCounterKey);
            this.actorCounters.put(actorCounterKey, counter);
        }
        counter.inc();
        String startTimeKey = OrbitActorExtension.getActorStartTimeKey(actor);
        this.actorStartTimes.put(startTimeKey, System.currentTimeMillis());
        String actorLifeSpanHistogramKey = OrbitActorExtension.getActorLifeSpanHistogramMetricsKey(actor.getClass());
        Histogram histogram = this.actorLifeSpanHistograms.get(actorLifeSpanHistogramKey);
        if (null == histogram) {
            histogram = MetricsManager.getInstance().getRegistry().histogram(OrbitActorExtension.getActorLifeSpanHistogramMetricsKey(actor.getClass()));
            this.actorLifeSpanHistograms.put(actorLifeSpanHistogramKey, histogram);
        }
        return Task.done();
    }

    public Task<?> postDeactivation(AbstractActor<?> actor) {
        String actorCounterKey = OrbitActorExtension.getActorCounterMetricsKey(actor.getClass());
        Counter counter = MetricsManager.getInstance().getRegistry().counter(actorCounterKey);
        counter.dec();
        String startTimeKey = OrbitActorExtension.getActorStartTimeKey(actor);
        Long starTime = this.actorStartTimes.get(startTimeKey);
        if (null != starTime) {
            String actorLifeSpanHistogramKey;
            Histogram histogram;
            if (null != starTime) {
                this.actorStartTimes.remove(startTimeKey);
            }
            if (null != (histogram = this.actorLifeSpanHistograms.get(actorLifeSpanHistogramKey = OrbitActorExtension.getActorLifeSpanHistogramMetricsKey(actor.getClass())))) {
                histogram.update(System.currentTimeMillis() - starTime);
            }
        }
        return Task.done();
    }

    public static String getActorStartTimeKey(AbstractActor<?> actor) {
        Object id = RemoteReference.getId(actor);
        return String.format("actors.%s.%s.starttime", actor.getClass().getSimpleName(), id);
    }

    public static String getActorMessageReceiveRateMetricKey(Class actorClass) {
        return String.format("orbit.actors.msg_received_rate[[actor:%s]]", actorClass.getSimpleName());
    }

    public static String getActorCounterMetricsKey(Class actorClass) {
        return String.format("orbit.actors.count[actor:%s]", actorClass.getSimpleName());
    }

    public static String getActorLifeSpanHistogramMetricsKey(Class actorClass) {
        return String.format("orbit.actors.lifespanhistogram[actor:%s]", actorClass.getSimpleName());
    }
}

