/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.metrics.dropwizard;

import cloud.orbit.actors.extensions.metrics.dropwizard.ReporterConfig;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.coursera.metrics.datadog.DatadogReporter;
import org.coursera.metrics.datadog.transport.HttpTransport;
import org.coursera.metrics.datadog.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogReporterConfig
extends ReporterConfig {
    private static final Logger logger = LoggerFactory.getLogger(DatadogReporterConfig.class);
    private String host;
    private String apiKey;

    public synchronized ScheduledReporter enableReporter(MetricRegistry registry) {
        HttpTransport httpTransport = new HttpTransport.Builder().withApiKey(this.apiKey).build();
        DatadogReporter datadogReporter = null;
        try {
            datadogReporter = DatadogReporter.forRegistry((MetricRegistry)registry).withHost(InetAddress.getLocalHost().getCanonicalHostName()).withPrefix(this.getPrefix()).withTransport((Transport)httpTransport).build();
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage());
        }
        datadogReporter.start((long)this.getPeriod(), this.getPeriodTimeUnit());
        return datadogReporter;
    }

    public String getHost() {
        return this.host;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

