/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;
    private int mark;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.buffer.hasRemaining()) {
            length = Math.min(length, this.buffer.remaining());
            this.buffer.get(bytes, offset, length);
            return length;
        }
        return -1;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.buffer.position();
    }

    @Override
    public void reset() throws IOException {
        this.buffer.position(this.mark);
    }
}

