/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.reflect;

import cloud.orbit.reflect.ClassDescriptor;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClassCache {
    private WeakHashMap<Class<?>, ClassDescriptor<?>> map = new WeakHashMap();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    public static final ClassCache shared = new ClassCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ClassDescriptor<T> getClass(Class<T> clazz) {
        ClassDescriptor<?> desc;
        this.lock.readLock().lock();
        try {
            desc = this.map.get(clazz);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (desc != null) {
            return desc;
        }
        desc = this.createClassDescriptor(clazz);
        this.lock.writeLock().lock();
        try {
            this.map.put(clazz, desc);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return desc;
    }

    protected <T> ClassDescriptor<?> createClassDescriptor(Class<T> clazz) {
        return new ClassDescriptor<T>(this, clazz);
    }
}

