/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.profiler;

import cloud.orbit.profiler.ProfilerData;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ProfilerCollector {
    public static final String GLOBAL = "global";
    private Map<Object, ProfilerData> collectedData = new WeakHashMap<Object, ProfilerData>();

    public void collect() {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        Thread currentThread = Thread.currentThread();
        for (Thread thread : threads) {
            if (currentThread == thread) continue;
            this.collect(thread);
        }
    }

    public void collect(Thread thread) {
        StackTraceElement[] stackTrace = thread.getStackTrace();
        this.collectByKey(GLOBAL, stackTrace);
    }

    public void collectByKey(Object key, StackTraceElement[] stackTrace) {
        ProfilerData profilerData = this.collectedData.get(key);
        if (profilerData == null) {
            profilerData = new ProfilerData();
            this.collectedData.put(key, profilerData);
        }
        profilerData.collect(stackTrace);
    }

    public Map<Object, ProfilerData> getProfilerData() {
        return this.collectedData;
    }

    public void clear() {
        this.collectedData.clear();
    }
}

