/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.tuples;

public class Triple<L, M, R> {
    private final L left;
    private final M middle;
    private final R right;

    protected Triple(L left, M middle, R right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    public static <L, M, R> Triple<L, M, R> of(L left, M middle, R right) {
        return new Triple<L, M, R>(left, middle, right);
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public M getMiddle() {
        return this.middle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triple triple = (Triple)o;
        if (this.left != null ? !this.left.equals(triple.left) : triple.left != null) {
            return false;
        }
        if (this.middle != null ? !this.middle.equals(triple.middle) : triple.middle != null) {
            return false;
        }
        return !(this.right == null ? triple.right != null : !this.right.equals(triple.right));
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.middle != null ? this.middle.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }
}

