/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.profiler;

import cloud.orbit.util.StringUtils;

public class MethodInfo {
    String declaringClass;
    String methodName;
    String fileName;
    long count;
    public long stamp;

    public MethodInfo() {
    }

    public MethodInfo(StackTraceElement e) {
        if (e != null) {
            this.declaringClass = e.getClassName();
            this.methodName = e.getMethodName();
            this.fileName = e.getFileName();
        } else {
            this.declaringClass = "<root>";
            this.methodName = "<root>";
            this.fileName = "<root>";
        }
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getCount() {
        return this.count;
    }

    public boolean equals(Object obj) {
        MethodInfo other = (MethodInfo)obj;
        return StringUtils.equals(this.declaringClass, other.declaringClass) && StringUtils.equals(this.methodName, other.methodName);
    }

    public int hashCode() {
        return this.declaringClass.hashCode() + (this.methodName != null ? this.methodName.hashCode() : 0) * 31;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getStamp() {
        return this.stamp;
    }

    public void setStamp(long stamp) {
        this.stamp = stamp;
    }
}

