/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.util;

import cloud.orbit.exception.UncheckedException;
import java.io.IOException;
import java.net.ServerSocket;

public class NetUtils {
    private NetUtils() {
    }

    public static int findFreePort() {
        int n;
        ServerSocket socket1 = new ServerSocket(0);
        try {
            n = socket1.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedException("Error trying to find a free port", e);
            }
        }
        socket1.close();
        return n;
    }

    public static int findFreePort(int start) {
        if (start == 0) {
            return NetUtils.findFreePort();
        }
        int i = start;
        while (i < 65535) {
            int n;
            ServerSocket socket1 = new ServerSocket();
            try {
                n = socket1.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    i = (int)((double)i + Math.random() * 50.0);
                }
            }
            socket1.close();
            return n;
        }
        throw new UncheckedException("No free ports found");
    }
}

