/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.concurrent;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class TaskContext {
    private static final ThreadLocal<Deque<TaskContext>> contextStacks = new ThreadLocal();
    private static final WeakHashMap<Thread, Deque<TaskContext>> contextStacksMap = new WeakHashMap();
    private static final AtomicLong nextId = new AtomicLong(1L);
    private long id = nextId.getAndIncrement();
    private ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap();
    private Executor defaultExecutor = null;

    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public void setDefaultExecutor(Executor defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push() {
        Deque<TaskContext> stack = contextStacks.get();
        if (stack == null) {
            stack = new LinkedList<TaskContext>();
            contextStacks.set(stack);
            Thread currentThread = Thread.currentThread();
            WeakHashMap<Thread, Deque<TaskContext>> weakHashMap = contextStacksMap;
            synchronized (weakHashMap) {
                contextStacksMap.put(currentThread, stack);
            }
        }
        stack.addLast(this);
    }

    public void pop() {
        Deque<TaskContext> stack = contextStacks.get();
        if (stack == null) {
            throw new IllegalStateException("Invalid execution context stack state: " + stack + " trying to remove: " + this);
        }
        TaskContext last = stack.pollLast();
        if (last != this) {
            if (last != null) {
                stack.addLast(last);
            }
            throw new IllegalStateException("Invalid execution context stack state: " + stack + " trying to remove: " + this + " but got: " + last);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.id;
    }

    public static TaskContext current() {
        Deque<TaskContext> stack = contextStacks.get();
        if (stack == null) {
            return null;
        }
        return stack.peekLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskContext currentFor(Thread thread) {
        Deque<TaskContext> stack;
        WeakHashMap<Thread, Deque<TaskContext>> weakHashMap = contextStacksMap;
        synchronized (weakHashMap) {
            stack = contextStacksMap.get(thread);
        }
        return stack != null ? stack.peek() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Thread> activeThreads() {
        WeakHashMap<Thread, Deque<TaskContext>> weakHashMap = contextStacksMap;
        synchronized (weakHashMap) {
            return new HashSet<Thread>(contextStacksMap.keySet());
        }
    }

    public static Runnable wrap(Runnable w) {
        TaskContext c = TaskContext.current();
        if (c != null) {
            return () -> {
                c.push();
                try {
                    w.run();
                }
                finally {
                    c.pop();
                }
            };
        }
        return w;
    }

    public static <T, U> BiConsumer<T, U> wrap(BiConsumer<T, U> w) {
        TaskContext c = TaskContext.current();
        if (c != null) {
            return (t, u) -> {
                c.push();
                try {
                    w.accept(t, u);
                }
                finally {
                    c.pop();
                }
            };
        }
        return w;
    }

    public static <T> Consumer<T> wrap(Consumer<T> w) {
        TaskContext c = TaskContext.current();
        if (c != null) {
            return t -> {
                c.push();
                try {
                    w.accept(t);
                }
                finally {
                    c.pop();
                }
            };
        }
        return w;
    }

    public static <T, R> Function<T, R> wrap(Function<T, R> w) {
        TaskContext c = TaskContext.current();
        if (c != null) {
            return t -> {
                c.push();
                try {
                    Object r = w.apply(t);
                    return r;
                }
                finally {
                    c.pop();
                }
            };
        }
        return w;
    }

    public static <T, U, R> BiFunction<T, U, R> wrap(BiFunction<T, U, R> w) {
        TaskContext c = TaskContext.current();
        if (c != null) {
            return (t, u) -> {
                c.push();
                try {
                    Object r = w.apply(t, u);
                    return r;
                }
                finally {
                    c.pop();
                }
            };
        }
        return w;
    }

    public static <T> Supplier<T> wrap(Supplier<T> w) {
        TaskContext c = TaskContext.current();
        if (c != null) {
            return () -> {
                c.push();
                try {
                    Object t = w.get();
                    return t;
                }
                finally {
                    c.pop();
                }
            };
        }
        return w;
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (value != null) {
            this.properties.put(name, value);
        } else {
            this.properties.remove(name);
        }
    }

    protected Map<String, Object> properties() {
        return this.properties;
    }
}

