/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AnnotationCache<T extends Annotation> {
    private final Annotation nullAnnotation = new NullAnnotation(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return NullAnnotation.class;
        }
    };
    private final Class<T> annotationClazz;
    private ConcurrentMap<Method, Annotation> methodToAnnotationCache = new ConcurrentHashMap<Method, Annotation>();

    public AnnotationCache(Class<T> annotationClazz) {
        this.annotationClazz = annotationClazz;
    }

    public boolean isAnnotated(Method method) {
        if (method == null) {
            return false;
        }
        Annotation annotation = (Annotation)this.methodToAnnotationCache.get(method);
        if (annotation != null) {
            return annotation != this.nullAnnotation;
        }
        annotation = method.getAnnotation(this.annotationClazz);
        this.methodToAnnotationCache.putIfAbsent(method, annotation != null ? annotation : this.nullAnnotation);
        return annotation != null;
    }

    public T getAnnotation(Method method) {
        if (method == null) {
            return null;
        }
        Annotation annotation = (Annotation)this.methodToAnnotationCache.get(method);
        if (annotation != null) {
            return (T)(annotation != this.nullAnnotation ? annotation : null);
        }
        annotation = method.getAnnotation(this.annotationClazz);
        this.methodToAnnotationCache.putIfAbsent(method, annotation != null ? annotation : this.nullAnnotation);
        return (T)annotation;
    }

    private static @interface NullAnnotation {
    }
}

