/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.concurrent;

import cloud.orbit.concurrent.ExecutorUtils;
import cloud.orbit.concurrent.TaskContext;
import cloud.orbit.concurrent.TaskSupplier;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Task<T>
extends CompletableFuture<T> {
    private static Void NIL = null;
    private static Executor commonPool = ExecutorUtils.newScalingThreadPool(100);
    private static ScheduledExecutorService schedulerExecutor = new ScheduledThreadPoolExecutor(10, runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setDaemon(true);
        return thread;
    });
    final Executor defaultExecutor;

    public Task() {
        TaskContext context = TaskContext.current();
        this.defaultExecutor = context != null ? context.getDefaultExecutor() : null;
    }

    public static <T> Task<T> fromValue(T value) {
        Task<T> t = new Task<T>();
        t.internalComplete(value);
        return t;
    }

    public static <T> Task<T> fromException(Throwable ex) {
        Task<T> t = new Task<T>();
        t.internalCompleteExceptionally(ex);
        return t;
    }

    protected boolean internalComplete(T value) {
        return super.complete(value);
    }

    protected boolean internalCompleteExceptionally(Throwable ex) {
        return super.completeExceptionally(ex);
    }

    @Override
    @Deprecated
    public boolean complete(T value) {
        return super.complete(value);
    }

    @Override
    @Deprecated
    public boolean completeExceptionally(Throwable ex) {
        return super.completeExceptionally(ex);
    }

    public static <T> Task<T> from(CompletionStage<T> stage) {
        if (stage instanceof Task) {
            return (Task)stage;
        }
        Task t = new Task();
        stage.handle((? super T v, Throwable ex) -> {
            if (ex != null) {
                t.internalCompleteExceptionally((Throwable)ex);
            } else {
                t.internalComplete(v);
            }
            return null;
        });
        return t;
    }

    public static <T> Task<T> fromFuture(Future<T> future) {
        if (future instanceof Task) {
            return (Task)future;
        }
        if (future instanceof CompletionStage) {
            return Task.from((CompletionStage)((Object)future));
        }
        Task<T> t = new Task<T>();
        if (future.isDone()) {
            try {
                t.internalComplete(future.get());
            }
            catch (Throwable ex) {
                t.internalCompleteExceptionally(ex);
            }
            return t;
        }
        commonPool.execute(new TaskFutureAdapter<T>(t, future, commonPool, 5L, TimeUnit.MILLISECONDS));
        return t;
    }

    public Task<T> failAfter(long timeout, TimeUnit timeUnit) {
        Task t = new Task();
        ScheduledFuture<?> rr = schedulerExecutor.schedule(() -> {
            if (!t.isDone()) {
                t.internalCompleteExceptionally(new TimeoutException());
            }
        }, timeout, timeUnit);
        this.handle((T v, U ex) -> {
            rr.cancel(false);
            if (!t.isDone()) {
                if (ex != null) {
                    t.internalCompleteExceptionally((Throwable)ex);
                } else {
                    t.internalComplete(v);
                }
            }
            return null;
        });
        return t;
    }

    public static Task<Void> sleep(long time, TimeUnit timeUnit) {
        Task<Void> t = new Task<Void>();
        ScheduledFuture<?> rr = schedulerExecutor.schedule(() -> {
            if (!t.isDone()) {
                t.internalComplete(null);
            }
        }, time, timeUnit);
        return t;
    }

    public static Task<Void> done() {
        Task<Void> task = new Task<Void>();
        task.internalComplete(NIL);
        return task;
    }

    @Override
    public <U> Task<U> thenApply(Function<? super T, ? extends U> fn) {
        Function<? super T, ? extends U> wrap = TaskContext.wrap(fn);
        if (this.defaultExecutor != null) {
            return Task.from(super.thenApplyAsync((Function)wrap, this.defaultExecutor));
        }
        return Task.from(super.thenApply((Function)wrap));
    }

    public Task<Void> thenAccept(Consumer<? super T> action) {
        Consumer<? super T> wrap = TaskContext.wrap(action);
        if (this.defaultExecutor != null) {
            return Task.from(super.thenAcceptAsync((Consumer)wrap, this.defaultExecutor));
        }
        return Task.from(super.thenAccept((Consumer)wrap));
    }

    @Override
    public Task<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        BiConsumer<? super T, ? super Throwable> wrap = TaskContext.wrap(action);
        if (this.defaultExecutor != null) {
            return Task.from(super.whenCompleteAsync((BiConsumer)wrap, this.defaultExecutor));
        }
        return Task.from(super.whenComplete((BiConsumer)wrap));
    }

    public <U> Task<U> thenReturn(Supplier<U> supplier) {
        Supplier wrap = TaskContext.wrap(supplier);
        if (this.defaultExecutor != null) {
            return Task.from(super.thenApplyAsync((T x) -> wrap.get(), this.defaultExecutor));
        }
        return Task.from(super.thenApply((T x) -> wrap.get()));
    }

    @Override
    public <U> Task<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        Function<? super T, ? extends CompletionStage<U>> wrap = TaskContext.wrap(fn);
        if (this.defaultExecutor != null) {
            return Task.from(super.thenComposeAsync((Function)wrap, this.defaultExecutor));
        }
        return Task.from(super.thenCompose((Function)wrap));
    }

    public <U> Task<U> thenCompose(Supplier<? extends CompletionStage<U>> fn) {
        Supplier wrap = TaskContext.wrap(fn);
        if (this.defaultExecutor != null) {
            return Task.from(super.thenComposeAsync((T x) -> (CompletionStage)wrap.get(), this.defaultExecutor));
        }
        return Task.from(super.thenCompose((T x) -> (CompletionStage)wrap.get()));
    }

    @Override
    public <U> Task<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        BiFunction<? super T, Throwable, ? extends U> wrap = TaskContext.wrap(fn);
        if (this.defaultExecutor != null) {
            return Task.from(super.handleAsync((BiFunction)wrap, this.defaultExecutor));
        }
        return Task.from(super.handle((BiFunction)wrap));
    }

    @Override
    public Task<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return Task.from(super.exceptionally((Function)TaskContext.wrap(fn)));
    }

    @Override
    public Task<Void> thenRun(Runnable action) {
        Runnable wrap = TaskContext.wrap(action);
        if (this.defaultExecutor != null) {
            return Task.from(super.thenRunAsync(wrap, this.defaultExecutor));
        }
        return Task.from(super.thenRun(wrap));
    }

    public Task<Void> acceptEither(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer) {
        Consumer<? super T> wrap = TaskContext.wrap(consumer);
        if (this.defaultExecutor != null) {
            return Task.from(super.acceptEitherAsync((CompletionStage)completionStage, (Consumer)wrap, this.defaultExecutor));
        }
        return Task.from(super.acceptEither((CompletionStage)completionStage, (Consumer)wrap));
    }

    public Task<Void> acceptEitherAsync(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer) {
        Consumer<? super T> wrap = TaskContext.wrap(consumer);
        return Task.from(super.acceptEitherAsync((CompletionStage)completionStage, (Consumer)wrap));
    }

    public Task<Void> acceptEitherAsync(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer, Executor executor) {
        return Task.from(super.acceptEitherAsync((CompletionStage)completionStage, (Consumer)TaskContext.wrap(consumer), executor));
    }

    @Override
    public <U> Task<U> applyToEither(CompletionStage<? extends T> completionStage, Function<? super T, U> function) {
        Function<? super T, U> wrap = TaskContext.wrap(function);
        if (this.defaultExecutor != null) {
            return Task.from(super.applyToEitherAsync((CompletionStage)completionStage, (Function)wrap, this.defaultExecutor));
        }
        return Task.from(super.applyToEither((CompletionStage)completionStage, (Function)wrap));
    }

    @Override
    public <U> Task<U> applyToEitherAsync(CompletionStage<? extends T> completionStage, Function<? super T, U> function, Executor executor) {
        return Task.from(super.applyToEitherAsync((CompletionStage)completionStage, (Function)TaskContext.wrap(function), executor));
    }

    @Override
    public <U> Task<U> applyToEitherAsync(CompletionStage<? extends T> completionStage, Function<? super T, U> function) {
        return Task.from(super.applyToEitherAsync((CompletionStage)completionStage, (Function)TaskContext.wrap(function)));
    }

    @Override
    public <U> Task<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> biFunction, Executor executor) {
        BiFunction<? super T, Throwable, ? extends U> wrap = TaskContext.wrap(biFunction);
        return Task.from(super.handleAsync((BiFunction)wrap, executor));
    }

    @Override
    public <U> Task<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> biFunction) {
        BiFunction<? super T, Throwable, ? extends U> wrap = TaskContext.wrap(biFunction);
        return Task.from(super.handleAsync((BiFunction)wrap));
    }

    public Task<Void> runAfterBoth(CompletionStage<?> completionStage, Runnable runnable) {
        Runnable wrap = TaskContext.wrap(runnable);
        if (this.defaultExecutor != null) {
            return Task.from(super.runAfterBothAsync((CompletionStage)completionStage, wrap, this.defaultExecutor));
        }
        return Task.from(super.runAfterBoth((CompletionStage)completionStage, wrap));
    }

    public Task<Void> runAfterBothAsync(CompletionStage<?> completionStage, Runnable runnable) {
        return Task.from(super.runAfterBothAsync((CompletionStage)completionStage, TaskContext.wrap(runnable)));
    }

    public Task<Void> runAfterBothAsync(CompletionStage<?> completionStage, Runnable runnable, Executor executor) {
        return Task.from(super.runAfterBothAsync((CompletionStage)completionStage, TaskContext.wrap(runnable), executor));
    }

    public Task<Void> runAfterEither(CompletionStage<?> completionStage, Runnable runnable) {
        Runnable wrap = TaskContext.wrap(runnable);
        if (this.defaultExecutor != null) {
            return Task.from(super.runAfterEitherAsync((CompletionStage)completionStage, wrap, this.defaultExecutor));
        }
        return Task.from(super.runAfterEither((CompletionStage)completionStage, wrap));
    }

    public Task<Void> runAfterEitherAsync(CompletionStage<?> completionStage, Runnable runnable) {
        return Task.from(super.runAfterEitherAsync((CompletionStage)completionStage, TaskContext.wrap(runnable)));
    }

    public Task<Void> runAfterEitherAsync(CompletionStage<?> completionStage, Runnable runnable, Executor executor) {
        return Task.from(super.runAfterEitherAsync((CompletionStage)completionStage, TaskContext.wrap(runnable), executor));
    }

    public static Task<Void> runAsync(Runnable runnable) {
        return Task.from(CompletableFuture.runAsync(TaskContext.wrap(runnable)));
    }

    public static Task<Void> runAsync(Runnable runnable, Executor executor) {
        return Task.from(CompletableFuture.runAsync(TaskContext.wrap(runnable), executor));
    }

    public static <U> Task<U> supplyAsync(TaskSupplier<U> supplier) {
        return Task.from(CompletableFuture.supplyAsync(TaskContext.wrap(supplier))).thenCompose((T t) -> t);
    }

    public static <U> Task<U> supplyAsync(Supplier<U> supplier) {
        return Task.from(CompletableFuture.supplyAsync(TaskContext.wrap(supplier)));
    }

    public static <U> Task<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return Task.from(CompletableFuture.supplyAsync(TaskContext.wrap(supplier), executor));
    }

    public static <U> Task<U> supplyAsync(TaskSupplier<U> supplier, Executor executor) {
        return Task.from(CompletableFuture.supplyAsync(TaskContext.wrap(supplier), executor).thenCompose((T t) -> t));
    }

    public Task<Void> thenAcceptAsync(Consumer<? super T> consumer, Executor executor) {
        return Task.from(super.thenAcceptAsync((Consumer)TaskContext.wrap(consumer), executor));
    }

    public Task<Void> thenAcceptAsync(Consumer<? super T> consumer) {
        return Task.from(super.thenAcceptAsync((Consumer)TaskContext.wrap(consumer)));
    }

    public <U> Task<Void> thenAcceptBoth(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        BiConsumer<? super T, ? super U> wrap = TaskContext.wrap(biConsumer);
        if (this.defaultExecutor != null) {
            return Task.from(super.thenAcceptBothAsync((CompletionStage)completionStage, (BiConsumer)wrap, this.defaultExecutor));
        }
        return Task.from(super.thenAcceptBoth((CompletionStage)completionStage, (BiConsumer)wrap));
    }

    public <U> Task<Void> thenAcceptBothAsync(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer, Executor executor) {
        return Task.from(super.thenAcceptBothAsync((CompletionStage)completionStage, (BiConsumer)TaskContext.wrap(biConsumer), executor));
    }

    public <U> Task<Void> thenAcceptBothAsync(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        return Task.from(super.thenAcceptBothAsync((CompletionStage)completionStage, (BiConsumer)TaskContext.wrap(biConsumer)));
    }

    @Override
    public <U> Task<U> thenApplyAsync(Function<? super T, ? extends U> function, Executor executor) {
        Function<? super T, ? extends U> wrap = TaskContext.wrap(function);
        return Task.from(super.thenApplyAsync((Function)wrap, executor));
    }

    @Override
    public <U> Task<U> thenApplyAsync(Function<? super T, ? extends U> function) {
        Function<? super T, ? extends U> wrap = TaskContext.wrap(function);
        return Task.from(super.thenApplyAsync((Function)wrap));
    }

    @Override
    public <U, V> Task<V> thenCombine(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        BiFunction<? super T, ? super U, ? extends V> wrap = TaskContext.wrap(biFunction);
        if (this.defaultExecutor != null) {
            return Task.from(super.thenCombineAsync((CompletionStage)completionStage, (BiFunction)wrap, this.defaultExecutor));
        }
        return Task.from(super.thenCombine((CompletionStage)completionStage, (BiFunction)wrap));
    }

    @Override
    public <U, V> Task<V> thenCombineAsync(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction, Executor executor) {
        BiFunction<? super T, ? super U, ? extends V> wrap = TaskContext.wrap(biFunction);
        return Task.from(super.thenCombineAsync((CompletionStage)completionStage, (BiFunction)wrap, executor));
    }

    @Override
    public <U, V> Task<V> thenCombineAsync(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        BiFunction<? super T, ? super U, ? extends V> wrap = TaskContext.wrap(biFunction);
        return Task.from(super.thenCombineAsync((CompletionStage)completionStage, (BiFunction)wrap));
    }

    @Override
    public <U> Task<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> function, Executor executor) {
        Function<? super T, ? extends CompletionStage<U>> wrap = TaskContext.wrap(function);
        return Task.from(super.thenComposeAsync((Function)wrap, executor));
    }

    @Override
    public <U> Task<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> function) {
        Function<? super T, ? extends CompletionStage<U>> wrap = TaskContext.wrap(function);
        return Task.from(super.thenComposeAsync((Function)wrap));
    }

    @Override
    public Task<Void> thenRunAsync(Runnable runnable) {
        return Task.from(super.thenRunAsync(TaskContext.wrap(runnable)));
    }

    @Override
    public Task<Void> thenRunAsync(Runnable runnable, Executor executor) {
        return Task.from(super.thenRunAsync(TaskContext.wrap(runnable), executor));
    }

    @Override
    public Task<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> biConsumer) {
        return Task.from(super.whenCompleteAsync((BiConsumer)TaskContext.wrap(biConsumer)));
    }

    @Override
    public Task<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> biConsumer, Executor executor) {
        return Task.from(super.whenCompleteAsync((BiConsumer)TaskContext.wrap(biConsumer), executor));
    }

    public static Task<Void> allOf(CompletableFuture<?> ... cfs) {
        return Task.from(CompletableFuture.allOf(cfs));
    }

    public static <F extends CompletableFuture<?>, C extends Collection<F>> Task<Void> allOf(C cfs) {
        return Task.from(CompletableFuture.allOf(cfs.toArray((CompletableFuture[])new CompletableFuture[cfs.size()])));
    }

    public static <F extends CompletableFuture<?>> Task<Void> allOf(Stream<F> cfs) {
        List<CompletableFuture> futureList = cfs.collect(Collectors.toList());
        CompletableFuture[] futureArray = futureList.toArray(new CompletableFuture[futureList.size()]);
        return Task.from(CompletableFuture.allOf(futureArray));
    }

    public static Task<Object> anyOf(CompletableFuture<?> ... cfs) {
        return Task.from(CompletableFuture.anyOf(cfs));
    }

    public static <F extends CompletableFuture<?>> Task<Object> anyOf(Collection<F> cfs) {
        return Task.from(CompletableFuture.anyOf(cfs.toArray(new CompletableFuture[cfs.size()])));
    }

    public static <F extends CompletableFuture<?>> Task<Object> anyOf(Stream<F> cfs) {
        return Task.from(CompletableFuture.anyOf((CompletableFuture[])cfs.toArray(CompletableFuture[]::new)));
    }

    static class TaskFutureAdapter<T>
    implements Runnable {
        Task<T> task;
        Future<T> future;
        Executor executor;
        long waitTimeout;
        TimeUnit waitTimeoutUnit;

        public TaskFutureAdapter(Task<T> task, Future<T> future, Executor executor, long waitTimeout, TimeUnit waitTimeoutUnit) {
            this.task = task;
            this.future = future;
            this.executor = executor;
            this.waitTimeout = waitTimeout;
            this.waitTimeoutUnit = waitTimeoutUnit;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

