/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.reflect;

import cloud.orbit.exception.UncheckedException;
import cloud.orbit.reflect.ClassCache;
import cloud.orbit.reflect.FieldDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClassDescriptor<T> {
    private Class<T> clazz;
    private Map<String, FieldDescriptor> declaredFieldsMap;
    private volatile List<FieldDescriptor> declaredFields;
    private volatile ClassDescriptor<?> superClass;
    private ClassCache cache;
    private List<FieldDescriptor> allInstanceFields;

    public ClassDescriptor(ClassCache cache, Class<T> clazz) {
        this.cache = cache;
        this.init(clazz);
    }

    private void init(Class<T> clazz) {
        this.setClazz(clazz);
        this.declaredFields = this.createFieldDescriptors();
        this.declaredFieldsMap = new LinkedHashMap<String, FieldDescriptor>();
        for (FieldDescriptor fieldDescriptor : this.declaredFields) {
            this.declaredFieldsMap.put(fieldDescriptor.getName(), fieldDescriptor);
        }
        if (clazz == Object.class) {
            this.allInstanceFields = Collections.emptyList();
        } else {
            List<FieldDescriptor> parentFields = this.getSuperClass().getAllInstanceFields();
            List<FieldDescriptor> declaredFields = this.getDeclaredFields();
            ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>(parentFields.size() + this.getDeclaredFields().size());
            fields.addAll(parentFields);
            for (FieldDescriptor field : declaredFields) {
                int mod = field.getField().getModifiers();
                if (Modifier.isStatic(mod)) continue;
                fields.add(field);
            }
            this.allInstanceFields = Collections.unmodifiableList(fields);
        }
    }

    protected List<FieldDescriptor> createFieldDescriptors() {
        Field[] clazzDeclaredFields = this.clazz.getDeclaredFields();
        ArrayList<FieldDescriptor> declaredFields = new ArrayList<FieldDescriptor>(clazzDeclaredFields.length);
        for (Field f : clazzDeclaredFields) {
            FieldDescriptor fieldDescriptor = this.createFieldDescriptor(f);
            declaredFields.add(fieldDescriptor);
        }
        return Collections.unmodifiableList(declaredFields);
    }

    protected FieldDescriptor createFieldDescriptor(Field f) {
        return new FieldDescriptor(f);
    }

    public ClassDescriptor<?> getSuperClass() {
        return this.superClass != null ? this.superClass : (this.superClass = this.cache.getClass(this.getClazz().getSuperclass()));
    }

    public T newInstance() {
        try {
            return this.getClazz().newInstance();
        }
        catch (Exception e) {
            throw new UncheckedException(e);
        }
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Map<String, FieldDescriptor> getDeclaredFieldsMap() {
        return this.declaredFieldsMap;
    }

    public List<FieldDescriptor> getDeclaredFields() {
        return this.declaredFields;
    }

    public List<FieldDescriptor> getAllInstanceFields() {
        return this.allInstanceFields;
    }
}

