/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.util;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean equals(CharSequence s1, CharSequence s2) {
        return s1 == s2 || s1 != null && s2 != null && s1.equals(s2);
    }

    public static boolean isNotBlank(CharSequence s) {
        if (s != null) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBlank(CharSequence s) {
        if (s != null) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence s) {
        return s != null && s.length() != 0;
    }

    public static CharSequence uncapitalize(CharSequence s) {
        if (StringUtils.isNotBlank(s) && Character.isUpperCase(s.charAt(0))) {
            StringBuilder sb = new StringBuilder(s);
            sb.setCharAt(0, Character.toLowerCase(s.charAt(0)));
            return sb.toString();
        }
        return s;
    }

    public static CharSequence capitalize(CharSequence s) {
        if (StringUtils.isNotBlank(s) && !Character.isUpperCase(s.charAt(0))) {
            StringBuilder sb = new StringBuilder(s);
            sb.setCharAt(0, Character.toUpperCase(s.charAt(0)));
            return sb.toString();
        }
        return s;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static String defaultIfBlank(String str, String def) {
        return StringUtils.isBlank(str) ? def : str;
    }
}

