/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.profiler;

import cloud.orbit.profiler.CallTreeElement;
import cloud.orbit.profiler.MethodInfo;
import java.util.HashMap;
import java.util.Set;

public class ProfilerData {
    private CallTreeElement root = new CallTreeElement(new MethodInfo(null));
    private final HashMap<MethodInfo, MethodInfo> all = new HashMap();
    private long currentStamp = (long)(Math.random() * 9.223372036854776E18);

    public void collect(StackTraceElement[] stack) {
        ++this.root.elementInfo.count;
        ++this.root.count;
        CallTreeElement current = this.root;
        ++this.currentStamp;
        MethodInfo probe = new MethodInfo();
        int i = stack.length;
        int k = 0;
        while (--i >= 0 && k < 256) {
            CallTreeElement ce;
            StackTraceElement s = stack[i];
            if (s == null) continue;
            ++k;
            probe.declaringClass = s.getClassName();
            probe.methodName = s.getMethodName();
            probe.fileName = s.getFileName();
            MethodInfo e = this.all.get(probe);
            if (e == null) {
                e = new MethodInfo(s);
                this.all.put(e, e);
            }
            if (e.stamp != this.currentStamp) {
                ++e.count;
                e.stamp = this.currentStamp;
            }
            if ((ce = current.children.get(e)) == null) {
                current.children.putIfAbsent(e, new CallTreeElement(e));
                ce = current.children.get(e);
            }
            ++ce.count;
            current = ce;
        }
    }

    public void reset() {
        this.root = new CallTreeElement(new MethodInfo(null));
        this.all.clear();
    }

    public Set<MethodInfo> getMethods() {
        return this.all.keySet();
    }

    public CallTreeElement getCallTree() {
        return this.root;
    }

    public long getSampleCount() {
        return this.root.count;
    }
}

