/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.util;

import cloud.orbit.exception.UncheckedException;
import cloud.orbit.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ClassPath {
    public static final String CLASS_FILE_EXTENSION = ".class";
    private static Logger logger = Logger.getLogger(ClassPath.class.getName());
    private static volatile ClassPath sharedInstance;
    private static final Object MUTEX;
    private List<ResourceInfo> resources;
    private List<ClassResourceInfo> classes;

    public List<ResourceInfo> getAllResources() {
        return this.resources;
    }

    public List<ClassResourceInfo> getAllClasses() {
        return this.classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassPath from(ClassLoader classloader) throws IOException {
        ArrayList<ResourceInfo> resourceInfos = new ArrayList<ResourceInfo>();
        HashSet<String> seen = new HashSet<String>();
        LinkedList<URL> urlsQueue = new LinkedList<URL>();
        for (ClassLoader c = classloader; c != null; c = c.getParent()) {
            URL[] urls;
            ClassLoader loader = c;
            if (!(c instanceof URLClassLoader) || (urls = ((URLClassLoader)c).getURLs()) == null || urls.length == 0) continue;
            urlsQueue.addAll(Arrays.asList(urls));
            while (urlsQueue.size() > 0) {
                URL url = (URL)urlsQueue.remove();
                if (!seen.add(url.toString())) continue;
                if (!"file".equals(url.getProtocol())) {
                    if (logger.getLevel() != Level.INFO) continue;
                    logger.info("Ignoring classpath entry: " + url);
                    continue;
                }
                try {
                    JarFile jar;
                    block13: {
                        Path entryPath = Paths.get(url.toURI());
                        if (Files.isDirectory(entryPath, new LinkOption[0])) {
                            resourceInfos.addAll(Files.walk(entryPath, new FileVisitOption[0]).filter(x -> !Files.isDirectory(x, new LinkOption[0])).map(x -> ClassPath.createResourceInfo(entryPath.relativize((Path)x).toString().replace(File.separatorChar, '/'), loader)).collect(Collectors.toList()));
                            continue;
                        }
                        jar = null;
                        try {
                            String classpath;
                            jar = new JarFile(entryPath.toFile());
                            resourceInfos.addAll(Collections.list(jar.entries()).stream().filter(x -> !x.isDirectory()).map(x -> ClassPath.createResourceInfo(x.getName(), loader)).collect(Collectors.toList()));
                            Manifest manifest = jar.getManifest();
                            Attributes mainAttributes = manifest == null ? null : manifest.getMainAttributes();
                            String string = classpath = mainAttributes == null ? null : mainAttributes.getValue(Attributes.Name.CLASS_PATH.toString());
                            if (classpath == null) break block13;
                            for (String path : classpath.split(" ")) {
                                try {
                                    URI uri = new URI(path);
                                    urlsQueue.add((uri.isAbsolute() ? uri : new File(entryPath.toFile(), path).toURI()).toURL());
                                }
                                catch (URISyntaxException e) {
                                    logger.warning("Ignoring class path element: " + path + " from: " + entryPath);
                                }
                            }
                        }
                        catch (IOException ex) {
                            block14: {
                                try {
                                    if (!logger.isLoggable(Level.FINE)) break block14;
                                    logger.log(Level.FINE, "Ignoring unsupported or malformed jar resource: " + entryPath);
                                }
                                catch (Throwable throwable) {
                                    IOUtils.silentlyClose(jar);
                                    throw throwable;
                                }
                            }
                            IOUtils.silentlyClose(jar);
                            continue;
                        }
                    }
                    IOUtils.silentlyClose(jar);
                }
                catch (URISyntaxException ex) {
                    throw new UncheckedException("Error loading classpath resources from: " + url, ex);
                }
            }
        }
        ClassPath cp = new ClassPath();
        cp.resources = resourceInfos;
        cp.classes = resourceInfos.stream().filter(r -> r instanceof ClassResourceInfo).map(r -> (ClassResourceInfo)r).collect(Collectors.toList());
        return cp;
    }

    private static ResourceInfo createResourceInfo(String name, ClassLoader loader) {
        return name.endsWith(CLASS_FILE_EXTENSION) ? new ClassResourceInfo(name, loader) : new ResourceInfo(name, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassPath get() {
        ClassPath res = sharedInstance;
        if (res != null) {
            return res;
        }
        Object object = MUTEX;
        synchronized (object) {
            res = sharedInstance;
            if (res == null) {
                try {
                    sharedInstance = res = ClassPath.from(ClassPath.class.getClassLoader());
                }
                catch (IOException e) {
                    throw new UncheckedException(e);
                }
            }
        }
        return res;
    }

    public static String getNullSafePackageName(Class<?> clazz) {
        return clazz.getPackage() != null ? clazz.getPackage().getName() : "";
    }

    static {
        MUTEX = new Object();
    }

    public static class ClassResourceInfo
    extends ResourceInfo {
        private String className;

        private ClassResourceInfo(String resourceName, ClassLoader loader) {
            super(resourceName, loader);
        }

        public Class<?> load() throws ClassNotFoundException {
            return this.loader.loadClass(this.className);
        }

        public String getClassName() {
            return this.className != null ? this.className : (this.className = this.resourceName.substring(0, this.resourceName.length() - ClassPath.CLASS_FILE_EXTENSION.length()).replace('/', '.').intern());
        }
    }

    public static class ResourceInfo {
        protected String resourceName;
        protected ClassLoader loader;

        private ResourceInfo(String resourceName, ClassLoader loader) {
            this.resourceName = resourceName;
            this.loader = loader;
        }

        public URL url() {
            return this.loader.getResource(this.resourceName);
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

