/*
 * Decompiled with CFR 0.152.
 */
package orbit.client.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0002H\b\"\n\b\u0000\u0010\b\u0018\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u000bJ-\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\b0\r\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\n\"\b\b\u0000\u0010\b*\u00020\u00012\b\u0010\u0010\u001a\u0004\u0018\u0001H\b\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorbit/client/serializer/Serializer;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "validator", "Lcom/fasterxml/jackson/databind/jsontype/PolymorphicTypeValidator;", "deserialize", "T", "str", "", "(Ljava/lang/String;)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "serialize", "obj", "(Ljava/lang/Object;)Ljava/lang/String;", "orbit-client"})
public final class Serializer {
    private final PolymorphicTypeValidator validator;
    private final ObjectMapper mapper;

    @NotNull
    public final <T> String serialize(@Nullable T obj) {
        String string = this.mapper.writeValueAsString(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mapper.writeValueAsString(obj)");
        return string;
    }

    @NotNull
    public final <T> T deserialize(@NotNull String str, @NotNull Class<? extends T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Object object = this.mapper.readValue(str, clazz);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mapper.readValue(str, clazz)");
        return (T)object;
    }

    @NotNull
    public final /* synthetic */ <T> T deserialize(@NotNull String str) {
        int $i$f$deserialize = 0;
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.deserialize(str, Object.class);
    }

    public Serializer() {
        BasicPolymorphicTypeValidator basicPolymorphicTypeValidator = BasicPolymorphicTypeValidator.builder().allowIfBaseType(Object.class).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicPolymorphicTypeValidator, (String)"BasicPolymorphicTypeVali\u2026ss.java)\n        .build()");
        this.validator = (PolymorphicTypeValidator)basicPolymorphicTypeValidator;
        ObjectMapper objectMapper = new ObjectMapper().activateDefaultTyping(this.validator, ObjectMapper.DefaultTyping.EVERYTHING);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper()\n        .\u2026DefaultTyping.EVERYTHING)");
        this.mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)objectMapper);
    }
}

