/*
 * Decompiled with CFR 0.152.
 */
package orbit.client.net;

import java.net.URI;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import orbit.client.net.OrbitServiceLocatorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorbit/client/net/OrbitServiceLocator;", "", "host", "", "port", "", "namespace", "(Ljava/lang/String;ILjava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getNamespace", "getPort", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "orbit-client"})
public final class OrbitServiceLocator {
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String namespace;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        return "orbit://" + this.host + ':' + this.port + '/' + this.namespace;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    public OrbitServiceLocator(@NotNull String host, int port, @NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        this.host = host;
        this.port = port;
        this.namespace = namespace;
    }

    @NotNull
    public final String component1() {
        return this.host;
    }

    public final int component2() {
        return this.port;
    }

    @NotNull
    public final String component3() {
        return this.namespace;
    }

    @NotNull
    public final OrbitServiceLocator copy(@NotNull String host, int port, @NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        return new OrbitServiceLocator(host, port, namespace);
    }

    public static /* synthetic */ OrbitServiceLocator copy$default(OrbitServiceLocator orbitServiceLocator, String string, int n, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = orbitServiceLocator.host;
        }
        if ((n2 & 2) != 0) {
            n = orbitServiceLocator.port;
        }
        if ((n2 & 4) != 0) {
            string2 = orbitServiceLocator.namespace;
        }
        return orbitServiceLocator.copy(string, n, string2);
    }

    public int hashCode() {
        String string = this.host;
        String string2 = this.namespace;
        return ((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.port)) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof OrbitServiceLocator)) break block3;
                OrbitServiceLocator orbitServiceLocator = (OrbitServiceLocator)object;
                if (!Intrinsics.areEqual((Object)this.host, (Object)orbitServiceLocator.host) || this.port != orbitServiceLocator.port || !Intrinsics.areEqual((Object)this.namespace, (Object)orbitServiceLocator.namespace)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0011\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorbit/client/net/OrbitServiceLocator$Companion;", "", "()V", "fromURI", "Lorbit/client/net/OrbitServiceLocator;", "uri", "Ljava/net/URI;", "invoke", "", "orbit-client"})
    public static final class Companion {
        @NotNull
        public final OrbitServiceLocator invoke(@NotNull URI uri) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            return OrbitServiceLocatorKt.toServiceLocator(uri);
        }

        @NotNull
        public final OrbitServiceLocator invoke(@NotNull String uri) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            return this.invoke(new URI(uri));
        }

        @NotNull
        public final OrbitServiceLocator fromURI(@NotNull URI uri) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            String string = uri.getScheme();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.scheme");
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            string2 = "orbit";
            String string5 = string4;
            bl = false;
            String string6 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
            String string7 = string6;
            boolean bl2 = Intrinsics.areEqual((Object)string5, (Object)string7);
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string8 = "Scheme must be orbit.";
                throw (Throwable)new IllegalArgumentException(string8.toString());
            }
            CharSequence charSequence = uri.getPath();
            bl = false;
            bl3 = false;
            boolean bl5 = !(charSequence == null || charSequence.length() == 0) && Intrinsics.areEqual((Object)uri.getPath(), (Object)"/") ^ true;
            bl = false;
            bl3 = false;
            if (!bl5) {
                boolean bl6 = false;
                String string9 = "A namespace must be specified.";
                throw (Throwable)new IllegalArgumentException(string9.toString());
            }
            bl5 = uri.getPort() != -1;
            bl = false;
            bl3 = false;
            if (!bl5) {
                boolean bl7 = false;
                String string10 = "A port must be explicitly specified.";
                throw (Throwable)new IllegalArgumentException(string10.toString());
            }
            String string11 = uri.getHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"uri.host");
            int n = uri.getPort();
            String string12 = uri.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"uri.path");
            return new OrbitServiceLocator(string11, n, StringsKt.trimStart((String)string12, (char[])new char[]{'/'}));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

