/*
 * Decompiled with CFR 0.152.
 */
package orbit.client.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import mu.KLogger;
import mu.KotlinLogging;
import orbit.client.OrbitClientConfig;
import orbit.client.addressable.InvocationSystem;
import orbit.client.net.ConnectionHandler;
import orbit.client.net.MessageHandler;
import orbit.client.util.MessageException;
import orbit.shared.net.Message;
import orbit.shared.net.MessageContent;
import orbit.util.time.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0014\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0015j\u0004\u0018\u0001`\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001d\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015j\u0002`\u00162\u0006\u0010\u001e\u001a\u00020\u001bJ\u0006\u0010\u001f\u001a\u00020\u0019R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lorbit/client/net/MessageHandler;", "", "connectionHandler", "Lorbit/client/net/ConnectionHandler;", "clock", "Lorbit/util/time/Clock;", "invocationSystem", "Lorbit/client/addressable/InvocationSystem;", "config", "Lorbit/client/OrbitClientConfig;", "(Lorbit/client/net/ConnectionHandler;Lorbit/util/time/Clock;Lorbit/client/addressable/InvocationSystem;Lorbit/client/OrbitClientConfig;)V", "awaitingResponse", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorbit/client/net/MessageHandler$ResponseEntry;", "logger", "Lmu/KLogger;", "messageCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "messageTimeoutMs", "getCompletion", "Lkotlinx/coroutines/CompletableDeferred;", "Lorbit/client/net/Completion;", "messageId", "onMessage", "", "message", "Lorbit/shared/net/Message;", "(Lorbit/shared/net/Message;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendMessage", "msg", "tick", "ResponseEntry", "orbit-client"})
public final class MessageHandler {
    private final KLogger logger;
    private final AtomicLong messageCounter;
    private final ConcurrentHashMap<Long, ResponseEntry> awaitingResponse;
    private final long messageTimeoutMs;
    private final ConnectionHandler connectionHandler;
    private final Clock clock;
    private final InvocationSystem invocationSystem;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object onMessage(@NotNull Message message, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof onMessage.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ MessageHandler this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.onMessage(null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = messageHandler;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = message.getContent();
                if (var3_6 instanceof MessageContent.Error || var3_6 instanceof MessageContent.InvocationResponse) {
                    v0 = message.getMessageId();
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    messageId = v0;
                    v1 = this.getCompletion(messageId);
                    if (v1 != null) {
                        var6_8 = v1;
                        var7_9 = false;
                        var8_10 = false;
                        completion = var6_8;
                        $i$a$-also-MessageHandler$onMessage$2 = false;
                        content = message.getContent();
                        if (content instanceof MessageContent.Error) {
                            completion.completeExceptionally((Throwable)new MessageException("Exceptional response received: " + ((MessageContent.Error)content).getDescription()));
                        } else if (content instanceof MessageContent.InvocationResponse) {
                            this.invocationSystem.onInvocationResponse(((MessageContent.InvocationResponse)content).getData(), completion);
                        }
                    }
                } else if (var3_6 instanceof MessageContent.InvocationRequest) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = message;
                    $continuation.label = 1;
                    v2 = this.invocationSystem.onInvocationRequest(message, (Continuation<? super Unit>)$continuation);
                    if (v2 == var14_5) {
                        return var14_5;
                    }
                }
                ** GOTO lbl48
            }
            case 1: {
                message = (Message)$continuation.L$1;
                this = (MessageHandler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl48:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final CompletableDeferred<Object> sendMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Long l = msg.getMessageId();
        long messageId = l != null ? l.longValue() : this.messageCounter.incrementAndGet();
        Message newMsg = Message.copy$default((Message)msg, null, (Long)messageId, null, null, (int)13, null);
        ResponseEntry entry = new ResponseEntry(messageId, newMsg, (CompletableDeferred<Object>)CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null), this.clock.getCurrentTime());
        if (newMsg.getContent() instanceof MessageContent.InvocationRequest) {
            ((Map)this.awaitingResponse).put(messageId, entry);
        } else {
            entry.getCompletion().complete((Object)Unit.INSTANCE);
        }
        this.connectionHandler.send(newMsg);
        return entry.getCompletion();
    }

    /*
     * WARNING - void declaration
     */
    public final void tick() {
        void $this$filterTo$iv$iv;
        Collection<ResponseEntry> collection = this.awaitingResponse.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"awaitingResponse.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResponseEntry it = (ResponseEntry)element$iv$iv;
            boolean bl = false;
            if (!(it.getTimeAdded() < this.clock.getCurrentTime() - this.messageTimeoutMs)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResponseEntry it = (ResponseEntry)element$iv;
            boolean bl = false;
            String content = "Response timed out after " + (this.clock.getCurrentTime() - it.getTimeAdded()) + "ms, timeout is" + ' ' + this.messageTimeoutMs + "ms. " + it.getMsg();
            this.logger.warn(content);
            it.getCompletion().completeExceptionally((Throwable)new MessageException(content));
            this.awaitingResponse.remove(it.getMessageId());
        }
    }

    private final CompletableDeferred<Object> getCompletion(long messageId) {
        ResponseEntry msg = this.awaitingResponse.remove(messageId);
        if (msg == null) {
            this.logger.warn("Response for unknown message " + messageId + " received. Did it time out? " + "(>" + this.messageTimeoutMs + "ms).");
        }
        ResponseEntry responseEntry = msg;
        return responseEntry != null ? responseEntry.getCompletion() : null;
    }

    public MessageHandler(@NotNull ConnectionHandler connectionHandler, @NotNull Clock clock, @NotNull InvocationSystem invocationSystem, @NotNull OrbitClientConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)connectionHandler, (String)"connectionHandler");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)invocationSystem, (String)"invocationSystem");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.connectionHandler = connectionHandler;
        this.clock = clock;
        this.invocationSystem = invocationSystem;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.messageCounter = new AtomicLong(0L);
        this.awaitingResponse = new ConcurrentHashMap();
        this.messageTimeoutMs = config.getMessageTimeout().toMillis();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0003j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u0002`\bH\u00c6\u0003J\r\u0010\u0016\u001a\u00060\u0003j\u0002`\nH\u00c6\u0003JA\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0003j\u0002`\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\t\u001a\u00060\u0003j\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorbit/client/net/MessageHandler$ResponseEntry;", "", "messageId", "", "msg", "Lorbit/shared/net/Message;", "completion", "Lkotlinx/coroutines/CompletableDeferred;", "Lorbit/client/net/Completion;", "timeAdded", "Lorbit/util/time/TimeMs;", "(JLorbit/shared/net/Message;Lkotlinx/coroutines/CompletableDeferred;J)V", "getCompletion", "()Lkotlinx/coroutines/CompletableDeferred;", "getMessageId", "()J", "getMsg", "()Lorbit/shared/net/Message;", "getTimeAdded", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "orbit-client"})
    private static final class ResponseEntry {
        private final long messageId;
        @NotNull
        private final Message msg;
        @NotNull
        private final CompletableDeferred<Object> completion;
        private final long timeAdded;

        public final long getMessageId() {
            return this.messageId;
        }

        @NotNull
        public final Message getMsg() {
            return this.msg;
        }

        @NotNull
        public final CompletableDeferred<Object> getCompletion() {
            return this.completion;
        }

        public final long getTimeAdded() {
            return this.timeAdded;
        }

        public ResponseEntry(long messageId, @NotNull Message msg, @NotNull CompletableDeferred<Object> completion, long timeAdded) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
            this.messageId = messageId;
            this.msg = msg;
            this.completion = completion;
            this.timeAdded = timeAdded;
        }

        public final long component1() {
            return this.messageId;
        }

        @NotNull
        public final Message component2() {
            return this.msg;
        }

        @NotNull
        public final CompletableDeferred<Object> component3() {
            return this.completion;
        }

        public final long component4() {
            return this.timeAdded;
        }

        @NotNull
        public final ResponseEntry copy(long messageId, @NotNull Message msg, @NotNull CompletableDeferred<Object> completion, long timeAdded) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
            return new ResponseEntry(messageId, msg, completion, timeAdded);
        }

        public static /* synthetic */ ResponseEntry copy$default(ResponseEntry responseEntry, long l, Message message, CompletableDeferred completableDeferred, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = responseEntry.messageId;
            }
            if ((n & 2) != 0) {
                message = responseEntry.msg;
            }
            if ((n & 4) != 0) {
                completableDeferred = responseEntry.completion;
            }
            if ((n & 8) != 0) {
                l2 = responseEntry.timeAdded;
            }
            return responseEntry.copy(l, message, completableDeferred, l2);
        }

        @NotNull
        public String toString() {
            return "ResponseEntry(messageId=" + this.messageId + ", msg=" + this.msg + ", completion=" + this.completion + ", timeAdded=" + this.timeAdded + ")";
        }

        public int hashCode() {
            Message message = this.msg;
            CompletableDeferred<Object> completableDeferred = this.completion;
            return ((Long.hashCode(this.messageId) * 31 + (message != null ? message.hashCode() : 0)) * 31 + (completableDeferred != null ? completableDeferred.hashCode() : 0)) * 31 + Long.hashCode(this.timeAdded);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ResponseEntry)) break block3;
                    ResponseEntry responseEntry = (ResponseEntry)object;
                    if (this.messageId != responseEntry.messageId || !Intrinsics.areEqual((Object)this.msg, (Object)responseEntry.msg) || !Intrinsics.areEqual(this.completion, responseEntry.completion) || this.timeAdded != responseEntry.timeAdded) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

