/*
 * Decompiled with CFR 0.152.
 */
package orbit.client.addressable;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import orbit.client.addressable.Addressable;
import orbit.client.addressable.AddressableProxy;
import orbit.client.addressable.InvocationSystem;
import orbit.shared.addressable.AddressableReference;
import orbit.shared.addressable.Key;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\u0005\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorbit/client/addressable/AddressableProxyFactory;", "", "invocationSystem", "Lorbit/client/addressable/InvocationSystem;", "(Lorbit/client/addressable/InvocationSystem;)V", "createProxy", "T", "Lorbit/client/addressable/Addressable;", "interfaceClass", "Ljava/lang/Class;", "key", "Lorbit/shared/addressable/Key;", "(Ljava/lang/Class;Lorbit/shared/addressable/Key;)Lorbit/client/addressable/Addressable;", "orbit-client"})
public final class AddressableProxyFactory {
    private final InvocationSystem invocationSystem;

    @NotNull
    public final <T extends Addressable> T createProxy(@NotNull Class<T> interfaceClass, @NotNull Key key) {
        Intrinsics.checkParameterIsNotNull(interfaceClass, (String)"interfaceClass");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class[] classArray = new Class[]{interfaceClass};
        String string = interfaceClass.getCanonicalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"interfaceClass.canonicalName");
        Object object = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new AddressableProxy(new AddressableReference(string, key), this.invocationSystem));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)((Addressable)object);
    }

    public AddressableProxyFactory(@NotNull InvocationSystem invocationSystem) {
        Intrinsics.checkParameterIsNotNull((Object)invocationSystem, (String)"invocationSystem");
        this.invocationSystem = invocationSystem;
    }
}

