/*
 * Decompiled with CFR 0.152.
 */
package orbit.client.addressable;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import orbit.client.OrbitClientConfig;
import orbit.client.addressable.Addressable;
import orbit.client.addressable.CapabilitiesScanner;
import orbit.client.addressable.NonConcrete;
import orbit.util.time.Clock;
import orbit.util.time.ElapsedAndResult;
import orbit.util.time.Stopwatch;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JB\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b0\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\t2\u001a\b\u0002\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b0\u001fH\u0002J\u0006\u0010 \u001a\u00020!RB\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b0\b2\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b0\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eRB\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b0\b2\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b0\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rf\u0010\u0012\u001a&\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b0\u00112*\u0010\u0007\u001a&\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b0\u0011@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006\""}, d2={"Lorbit/client/addressable/CapabilitiesScanner;", "", "clock", "Lorbit/util/time/Clock;", "config", "Lorbit/client/OrbitClientConfig;", "(Lorbit/util/time/Clock;Lorbit/client/OrbitClientConfig;)V", "<set-?>", "", "Ljava/lang/Class;", "Lorbit/client/addressable/Addressable;", "Lorbit/client/addressable/AddressableClass;", "addressableClasses", "getAddressableClasses", "()Ljava/util/List;", "addressableInterfaces", "getAddressableInterfaces", "", "interfaceLookup", "getInterfaceLookup", "()Ljava/util/Map;", "logger", "Lmu/KLogger;", "packagePaths", "", "", "[Ljava/lang/String;", "resolveMapping", "", "crawl", "list", "", "scan", "", "orbit-client"})
public final class CapabilitiesScanner {
    private final KLogger logger;
    private final String[] packagePaths;
    @NotNull
    private List<? extends Class<? extends Addressable>> addressableInterfaces;
    @NotNull
    private List<? extends Class<? extends Addressable>> addressableClasses;
    @NotNull
    private Map<Class<? extends Addressable>, ? extends Class<? extends Addressable>> interfaceLookup;
    private final Clock clock;

    @NotNull
    public final List<Class<? extends Addressable>> getAddressableInterfaces() {
        List<Class<? extends Addressable>> list = this.addressableInterfaces;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"addressableInterfaces");
        }
        return list;
    }

    @NotNull
    public final List<Class<? extends Addressable>> getAddressableClasses() {
        List<Class<? extends Addressable>> list = this.addressableClasses;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"addressableClasses");
        }
        return list;
    }

    @NotNull
    public final Map<Class<? extends Addressable>, Class<? extends Addressable>> getInterfaceLookup() {
        Map<Class<? extends Addressable>, Class<? extends Addressable>> map = this.interfaceLookup;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"interfaceLookup");
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scan() {
        this.logger.info("Scanning for node capabilities...");
        Clock clock$iv = this.clock;
        boolean $i$f$stopwatch = false;
        Stopwatch sw$iv = Stopwatch.Companion.start(clock$iv);
        boolean bl = false;
        ClassGraph classGraph = new ClassGraph().enableAllInfo().whitelistPackages(Arrays.copyOf(this.packagePaths, this.packagePaths.length));
        Closeable closeable = (Closeable)classGraph.scan();
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Class clazz;
            ClassInfo it;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            ScanResult scan2 = (ScanResult)closeable;
            boolean bl3 = false;
            ClassInfoList classInfoList = scan2.getClassesImplementing(Addressable.class.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)classInfoList, (String)"scan\n                   \u2026essable::class.java.name)");
            ClassInfoList classInfoList2 = classInfoList.getInterfaces().filter((ClassInfoList.ClassInfoFilter)scan.1.1.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)classInfoList2, (String)"scan\n                   \u2026me)\n                    }");
            Iterable iterable = (Iterable)classInfoList2;
            CapabilitiesScanner capabilitiesScanner = this;
            boolean $i$f$map = false;
            void var14_22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ClassInfo classInfo = (ClassInfo)item$iv$iv;
                object = destination$iv$iv;
                boolean bl4 = false;
                if (it.loadClass() == null) {
                    throw new TypeCastException("null cannot be cast to non-null type orbit.client.addressable.AddressableClass /* = java.lang.Class<out orbit.client.addressable.Addressable> */");
                }
                object.add(clazz);
            }
            object = (List)destination$iv$iv;
            capabilitiesScanner.addressableInterfaces = object;
            ClassInfoList classInfoList3 = scan2.getClassesImplementing(Addressable.class.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)classInfoList3, (String)"scan\n                   \u2026essable::class.java.name)");
            ClassInfoList classInfoList4 = classInfoList3.getStandardClasses().filter((ClassInfoList.ClassInfoFilter)scan.1.1.3.INSTANCE).filter((ClassInfoList.ClassInfoFilter)scan.1.1.4.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)classInfoList4, (String)"scan\n                   \u2026act\n                    }");
            $this$map$iv = (Iterable)classInfoList4;
            capabilitiesScanner = this;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ClassInfo)item$iv$iv;
                object = destination$iv$iv;
                boolean bl5 = false;
                if (it.loadClass() == null) {
                    throw new TypeCastException("null cannot be cast to non-null type orbit.client.addressable.AddressableClass /* = java.lang.Class<out orbit.client.addressable.Addressable> */");
                }
                object.add(clazz);
            }
            object = (List)destination$iv$iv;
            capabilitiesScanner.addressableClasses = object;
            capabilitiesScanner = this;
            boolean bl6 = false;
            Object object2 = object = (Map)new LinkedHashMap();
            boolean bl7 = false;
            boolean bl8 = false;
            Object $this$apply = object2;
            boolean bl9 = false;
            List<? extends Class<? extends Addressable>> list = this.addressableClasses;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"addressableClasses");
            }
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Class implClass = (Class)element$iv;
                boolean bl10 = false;
                Collection collection = CapabilitiesScanner.resolveMapping$default(this, implClass, null, 2, null);
                boolean bl11 = false;
                boolean bl12 = false;
                Collection mapped = collection;
                boolean bl13 = false;
                boolean bl14 = !mapped.isEmpty();
                boolean bl15 = false;
                boolean bl16 = false;
                if (!bl14) {
                    boolean bl17 = false;
                    String string = "Could not find mapping for " + implClass.getName();
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Iterable $this$forEach$iv2 = mapped;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Class iface = (Class)element$iv2;
                    boolean bl18 = false;
                    boolean bl19 = !$this$apply.containsKey(iface);
                    boolean bl20 = false;
                    boolean bl21 = false;
                    if (!bl19) {
                        boolean bl22 = false;
                        String string = "Multiple implementations of concrete interface " + iface.getName() + " found.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    $this$apply.put(iface, implClass);
                }
            }
            capabilitiesScanner.interfaceLookup = object = object2;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Unit computed$iv = Unit.INSTANCE;
        ElapsedAndResult elapsedAndResult = new ElapsedAndResult(sw$iv.getElapsed(), (Object)computed$iv);
        boolean bl23 = false;
        boolean bl24 = false;
        ElapsedAndResult $dstr$elapsed$_u24__u24 = elapsedAndResult;
        boolean bl25 = false;
        long elapsed = $dstr$elapsed$_u24__u24.component1();
        this.logger.debug((Function0)new Function0<String>(this){
            final /* synthetic */ CapabilitiesScanner this$0;
            {
                this.this$0 = capabilitiesScanner;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Addressable Interfaces: " + this.this$0.getAddressableInterfaces();
            }
        });
        this.logger.debug((Function0)new Function0<String>(this){
            final /* synthetic */ CapabilitiesScanner this$0;
            {
                this.this$0 = capabilitiesScanner;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Addressable Classes: " + this.this$0.getAddressableClasses();
            }
        });
        this.logger.debug((Function0)new Function0<String>(this){
            final /* synthetic */ CapabilitiesScanner this$0;
            {
                this.this$0 = capabilitiesScanner;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Implemented Addressables: " + this.this$0.getInterfaceLookup();
            }
        });
        this.logger.info((Function0)new Function0<String>(elapsed, this){
            final /* synthetic */ long $elapsed;
            final /* synthetic */ CapabilitiesScanner this$0;
            {
                this.$elapsed = l;
                this.this$0 = capabilitiesScanner;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Node capabilities scan complete in " + this.$elapsed + "ms. " + this.this$0.getInterfaceLookup().size() + " implemented addressable(s) found. " + this.this$0.getAddressableInterfaces().size() + " addressable interface(s) found. " + this.this$0.getAddressableClasses().size() + " addressable class(es) found. ";
            }
        });
    }

    private final Collection<Class<? extends Addressable>> resolveMapping(Class<?> crawl, List<Class<? extends Addressable>> list) {
        Class<?>[] classArray = crawl.getInterfaces();
        Intrinsics.checkExpressionValueIsNotNull(classArray, (String)"crawl.interfaces");
        Class<?>[] classArray2 = classArray;
        int n = 0;
        if (classArray2.length == 0) {
            return list;
        }
        for (Class<?> iface : crawl.getInterfaces()) {
            Class<?>[] classArray3;
            if (!Addressable.class.isAssignableFrom(iface)) continue;
            if (!iface.isAnnotationPresent(NonConcrete.class)) {
                Class<?> clazz = iface;
                if (clazz == null) {
                    throw new TypeCastException("null cannot be cast to non-null type orbit.client.addressable.AddressableClass /* = java.lang.Class<out orbit.client.addressable.Addressable> */");
                }
                list.add(clazz);
            }
            Class<?> clazz = iface;
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"iface");
            Intrinsics.checkExpressionValueIsNotNull(clazz.getInterfaces(), (String)"iface.interfaces");
            boolean bl = false;
            Class<?>[] classArray4 = classArray3;
            boolean bl2 = false;
            if (!(!(classArray4.length == 0))) continue;
            this.resolveMapping(iface, list);
        }
        return list;
    }

    static /* synthetic */ Collection resolveMapping$default(CapabilitiesScanner capabilitiesScanner, Class clazz, List list, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            list = new ArrayList();
        }
        return capabilitiesScanner.resolveMapping(clazz, list);
    }

    /*
     * WARNING - void declaration
     */
    public CapabilitiesScanner(@NotNull Clock clock, @NotNull OrbitClientConfig config) {
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.clock = clock;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        Collection collection = config.getPackages();
        CapabilitiesScanner capabilitiesScanner = this;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        capabilitiesScanner.packagePaths = stringArray2;
    }

    public static final /* synthetic */ List access$getAddressableInterfaces$p(CapabilitiesScanner $this) {
        List<? extends Class<? extends Addressable>> list = $this.addressableInterfaces;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"addressableInterfaces");
        }
        return list;
    }

    public static final /* synthetic */ void access$setAddressableInterfaces$p(CapabilitiesScanner $this, List list) {
        $this.addressableInterfaces = list;
    }

    public static final /* synthetic */ List access$getAddressableClasses$p(CapabilitiesScanner $this) {
        List<? extends Class<? extends Addressable>> list = $this.addressableClasses;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"addressableClasses");
        }
        return list;
    }

    public static final /* synthetic */ void access$setAddressableClasses$p(CapabilitiesScanner $this, List list) {
        $this.addressableClasses = list;
    }

    public static final /* synthetic */ Map access$getInterfaceLookup$p(CapabilitiesScanner $this) {
        Map<Class<? extends Addressable>, ? extends Class<? extends Addressable>> map = $this.interfaceLookup;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"interfaceLookup");
        }
        return map;
    }

    public static final /* synthetic */ void access$setInterfaceLookup$p(CapabilitiesScanner $this, Map map) {
        $this.interfaceLookup = map;
    }
}

