/*
 * Decompiled with CFR 0.152.
 */
package orbit.client.addressable;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import orbit.client.addressable.Addressable;
import orbit.client.addressable.AddressableDefinitionDirectory;
import orbit.client.addressable.AddressableImplDefinition;
import orbit.client.addressable.AddressableImplMethodDefinition;
import orbit.client.addressable.AddressableInterfaceDefinition;
import orbit.client.addressable.AddressableInterfaceMethodDefinition;
import orbit.client.addressable.NonConcrete;
import orbit.client.addressable.OnActivate;
import orbit.client.addressable.OnDeactivate;
import orbit.client.util.DeferredWrappers;
import orbit.shared.mesh.NodeCapabilities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J0\u0010\u0011\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u00072\u0012\u0010\u0013\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010\u001b\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007J\u001a\u0010\u001e\u001a\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007J.\u0010\u001f\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u00072\u0012\u0010\u0013\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007JL\u0010 \u001a\u00020!2\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u00070#2*\u0010$\u001a&\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u00070%J\u0010\u0010&\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R&\u0010\u0003\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000b\u001a2\u0012(\u0012&\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005j\u0002`\u00070\f\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorbit/client/addressable/AddressableDefinitionDirectory;", "", "()V", "implDefinitionMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "Lorbit/client/addressable/Addressable;", "Lorbit/client/addressable/AddressableClass;", "Lorbit/client/addressable/AddressableImplDefinition;", "interfaceDefinitionMap", "Lorbit/client/addressable/AddressableInterfaceDefinition;", "interfaceImplComboImplDefinitionMap", "Lkotlin/Pair;", "logger", "Lmu/KLogger;", "generateCapabilities", "Lorbit/shared/mesh/NodeCapabilities;", "generateImplDefinition", "interfaceClass", "implClass", "generateImplMethodDefinition", "Lorbit/client/addressable/AddressableImplMethodDefinition;", "method", "Ljava/lang/reflect/Method;", "generateInterfaceDefinition", "generateInterfaceMethodDefinition", "Lorbit/client/addressable/AddressableInterfaceMethodDefinition;", "getImplDefinition", "name", "", "getOrCreateInterfaceDefinition", "onDemandImplClass", "setupDefinition", "", "interfaceClasses", "", "impls", "", "verifyMethodIsAsync", "orbit-client"})
public final class AddressableDefinitionDirectory {
    private final ConcurrentHashMap<Class<? extends Addressable>, AddressableInterfaceDefinition> interfaceDefinitionMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Addressable>, AddressableImplDefinition> implDefinitionMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Pair<Class<? extends Addressable>, Class<? extends Addressable>>, AddressableImplDefinition> interfaceImplComboImplDefinitionMap = new ConcurrentHashMap();
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    public final void setupDefinition(@NotNull Iterable<? extends Class<? extends Addressable>> interfaceClasses, @NotNull Map<Class<? extends Addressable>, ? extends Class<? extends Addressable>> impls) {
        Intrinsics.checkParameterIsNotNull(interfaceClasses, (String)"interfaceClasses");
        Intrinsics.checkParameterIsNotNull(impls, (String)"impls");
        Object $this$forEach$iv = interfaceClasses;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Class<? extends Addressable> element$iv;
            Class<? extends Addressable> it = element$iv = object.next();
            boolean bl = false;
            this.getOrCreateInterfaceDefinition(it);
        }
        $this$forEach$iv = impls;
        $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$interfaceClass$implClass = element$iv = iterator.next();
            boolean bl2 = false;
            Object object2 = $dstr$interfaceClass$implClass;
            boolean bl3 = false;
            Class interfaceClass = (Class)object2.getKey();
            object2 = $dstr$interfaceClass$implClass;
            bl3 = false;
            Class implClass = (Class)object2.getValue();
            object2 = this.generateImplDefinition(interfaceClass, implClass);
            bl3 = false;
            boolean bl4 = false;
            Object it = object2;
            boolean bl5 = false;
            ((Map)this.implDefinitionMap).put(interfaceClass, it);
        }
    }

    @NotNull
    public final AddressableInterfaceDefinition getOrCreateInterfaceDefinition(@NotNull Class<? extends Addressable> interfaceClass) {
        Intrinsics.checkParameterIsNotNull(interfaceClass, (String)"interfaceClass");
        ConcurrentMap $this$getOrPut$iv = this.interfaceDefinitionMap;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(interfaceClass);
        if (object == null) {
            boolean bl = false;
            AddressableInterfaceDefinition addressableInterfaceDefinition = this.generateInterfaceDefinition(interfaceClass);
            boolean bl2 = false;
            boolean bl3 = false;
            AddressableInterfaceDefinition default$iv = addressableInterfaceDefinition;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(interfaceClass, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"interfaceDefinitionMap.g\u2026interfaceClass)\n        }");
        return (AddressableInterfaceDefinition)object;
    }

    @NotNull
    public final AddressableImplDefinition getImplDefinition(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Class<?> clazz = Class.forName(name);
        if (clazz == null) {
            throw new TypeCastException("null cannot be cast to non-null type orbit.client.addressable.AddressableClass /* = java.lang.Class<out orbit.client.addressable.Addressable> */");
        }
        return this.getImplDefinition(clazz);
    }

    @NotNull
    public final AddressableImplDefinition getImplDefinition(@NotNull Class<? extends Addressable> interfaceClass) {
        Intrinsics.checkParameterIsNotNull(interfaceClass, (String)"interfaceClass");
        AddressableImplDefinition addressableImplDefinition = this.implDefinitionMap.get(interfaceClass);
        if (addressableImplDefinition == null) {
            throw (Throwable)new IllegalStateException("No implementation found for " + interfaceClass);
        }
        return addressableImplDefinition;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AddressableImplDefinition onDemandImplClass(@NotNull Class<? extends Addressable> interfaceClass, @NotNull Class<? extends Addressable> implClass) {
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull(interfaceClass, (String)"interfaceClass");
        Intrinsics.checkParameterIsNotNull(implClass, (String)"implClass");
        ConcurrentMap concurrentMap = this.interfaceImplComboImplDefinitionMap;
        Pair key$iv = TuplesKt.to(interfaceClass, implClass);
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            AddressableImplDefinition addressableImplDefinition = this.generateImplDefinition(interfaceClass, implClass);
            boolean bl2 = false;
            boolean bl3 = false;
            AddressableImplDefinition default$iv = addressableImplDefinition;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"interfaceImplComboImplDe\u2026ass, implClass)\n        }");
        return (AddressableImplDefinition)object;
    }

    /*
     * WARNING - void declaration
     */
    private final AddressableInterfaceDefinition generateInterfaceDefinition(Class<? extends Addressable> interfaceClass) {
        void $this$mapTo$iv$iv;
        if (!interfaceClass.isInterface()) {
            throw (Throwable)new IllegalArgumentException(interfaceClass.getName() + " is not an interface.");
        }
        if (interfaceClass.isAnnotationPresent(NonConcrete.class)) {
            throw (Throwable)new IllegalArgumentException(interfaceClass.getName() + " is non-concrete and can not be directly addressed");
        }
        Method[] methodArray = interfaceClass.getMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"interfaceClass.methods");
        Method[] $this$map$iv = methodArray;
        boolean $i$f$map = false;
        Method[] methodArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_7 = $this$mapTo$iv$iv;
        int n = ((void)var8_7).length;
        for (int i = 0; i < n; ++i) {
            void method;
            void item$iv$iv;
            void var12_11 = item$iv$iv = var8_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = method;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"method");
            Pair pair = TuplesKt.to((Object)method, (Object)this.generateInterfaceMethodDefinition((Method)v1));
            collection.add(pair);
        }
        Map methods = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        AddressableInterfaceDefinition definition = new AddressableInterfaceDefinition(interfaceClass, methods);
        this.logger.debug((Function0)new Function0<String>(definition){
            final /* synthetic */ AddressableInterfaceDefinition $definition;

            @NotNull
            public final String invoke() {
                return "Created interface definition: " + this.$definition;
            }
            {
                this.$definition = addressableInterfaceDefinition;
                super(0);
            }
        });
        return definition;
    }

    private final AddressableInterfaceMethodDefinition generateInterfaceMethodDefinition(Method method) {
        this.verifyMethodIsAsync(method);
        return new AddressableInterfaceMethodDefinition(method);
    }

    /*
     * WARNING - void declaration
     */
    private final AddressableImplDefinition generateImplDefinition(Class<? extends Addressable> interfaceClass, Class<? extends Addressable> implClass) {
        AddressableImplMethodDefinition onDeactivateMethod;
        Object v3;
        AddressableImplMethodDefinition onActivateMethod;
        Map methods;
        AddressableInterfaceDefinition interfaceDef;
        block6: {
            Object v2;
            block5: {
                void $this$mapTo$iv$iv;
                interfaceDef = this.getOrCreateInterfaceDefinition(interfaceClass);
                Method[] methodArray = implClass.getMethods();
                Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"implClass.methods");
                Method[] $this$map$iv = methodArray;
                boolean $i$f$map = false;
                Method[] methodArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv;
                int n = ((void)iterator).length;
                for (int i = 0; i < n; ++i) {
                    void method;
                    void item$iv$iv;
                    void var14_29 = item$iv$iv = iterator[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = method;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"method");
                    Pair pair = TuplesKt.to((Object)method, (Object)this.generateImplMethodDefinition((Method)v1));
                    collection.add(pair);
                }
                methods = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                Iterable $this$singleOrNull$iv = methods.values();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    AddressableImplMethodDefinition it = (AddressableImplMethodDefinition)element$iv;
                    boolean bl = false;
                    if (!it.isOnActivate()) continue;
                    if (found$iv) {
                        v2 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            onActivateMethod = v2;
            Iterable $this$singleOrNull$iv = methods.values();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                AddressableImplMethodDefinition it = (AddressableImplMethodDefinition)element$iv;
                boolean bl = false;
                if (!it.isOnDeactivate()) continue;
                if (found$iv) {
                    v3 = null;
                    break block6;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v3 = !found$iv ? null : single$iv;
        }
        AddressableImplMethodDefinition addressableImplMethodDefinition = onDeactivateMethod = (AddressableImplMethodDefinition)v3;
        AddressableImplMethodDefinition addressableImplMethodDefinition2 = onActivateMethod;
        Map map = methods;
        AddressableInterfaceDefinition addressableInterfaceDefinition = interfaceDef;
        Class<? extends Addressable> clazz = implClass;
        Class<? extends Addressable> clazz2 = interfaceClass;
        AddressableImplDefinition definition = new AddressableImplDefinition(clazz, clazz2, addressableInterfaceDefinition, map, addressableImplMethodDefinition2, addressableImplMethodDefinition);
        this.logger.debug((Function0)new Function0<String>(definition){
            final /* synthetic */ AddressableImplDefinition $definition;

            @NotNull
            public final String invoke() {
                return "Created implementation definition: " + this.$definition;
            }
            {
                this.$definition = addressableImplDefinition;
                super(0);
            }
        });
        return definition;
    }

    private final AddressableImplMethodDefinition generateImplMethodDefinition(Method method) {
        boolean isOnActivate = method.isAnnotationPresent(OnActivate.class);
        boolean isOnDeactivate = method.isAnnotationPresent(OnDeactivate.class);
        if (isOnActivate || isOnDeactivate) {
            this.verifyMethodIsAsync(method);
        }
        return new AddressableImplMethodDefinition(method, isOnActivate, isOnDeactivate);
    }

    private final void verifyMethodIsAsync(Method method) {
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"method.returnType");
        boolean bl = DeferredWrappers.INSTANCE.canHandle(clazz);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Method " + method + " does not return asynchronous type.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NodeCapabilities generateCapabilities() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Map $this$map$iv = this.interfaceDefinitionMap;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void $dstr$key$_u24__u24;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            void var12_12 = $dstr$key$_u24__u24;
            boolean bl3 = false;
            Class key = (Class)var12_12.getKey();
            String string = key.getName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        Iterable iterable = collection;
        return new NodeCapabilities(iterable);
    }
}

