/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.actors.cluster.DistributedMap;
import cloud.orbit.actors.cluster.NodeAddress;
import cloud.orbit.actors.cluster.NodeAddressImpl;
import cloud.orbit.actors.test.FakeClusterPeer;
import cloud.orbit.concurrent.ExecutorUtils;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeGroup {
    private static final Logger logger = LoggerFactory.getLogger(FakeGroup.class);
    private static final LoadingCache<String, FakeGroup> groups = Caffeine.newBuilder().weakValues().build((CacheLoader)new CacheLoader<String, FakeGroup>(){

        public FakeGroup load(String key) throws Exception {
            return new FakeGroup(key);
        }
    });
    private final Map<NodeAddress, FakeClusterPeer> currentChannels = new HashMap<NodeAddress, FakeClusterPeer>();
    private final Object topologyMutex = new Object();
    private final LoadingCache<String, ConcurrentMap> maps = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<String, ConcurrentMap>(){

        public ConcurrentMap load(String key) throws Exception {
            return new ConcurrentHashMap();
        }
    });
    private int count = 0;
    private String clusterName;
    private static Executor pool = ExecutorUtils.newScalingThreadPool((int)20);

    public FakeGroup(String clusterName) {
        this.clusterName = clusterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeAddressImpl join(FakeClusterPeer fakeChannel) {
        Collection tasks;
        NodeAddressImpl nodeAddress;
        Object object = this.topologyMutex;
        synchronized (object) {
            String name = "channel." + ++this.count + "." + this.clusterName;
            nodeAddress = new NodeAddressImpl(new UUID(name.hashCode(), this.count));
            this.currentChannels.put((NodeAddress)nodeAddress, fakeChannel);
            fakeChannel.setAddress((NodeAddress)nodeAddress);
            ArrayList<NodeAddress> newView = new ArrayList<NodeAddress>(this.currentChannels.keySet());
            tasks = this.currentChannels.values().stream().map(ch -> CompletableFuture.runAsync(() -> ch.onViewChanged(newView), pool)).collect(Collectors.toList());
        }
        Task.allOf((Collection)tasks).join();
        return nodeAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(FakeClusterPeer fakeClusterPeer) {
        List tasks;
        Object object = this.topologyMutex;
        synchronized (object) {
            this.currentChannels.remove(fakeClusterPeer.localAddress());
            ArrayList<NodeAddress> newView = new ArrayList<NodeAddress>(this.currentChannels.keySet());
            tasks = this.currentChannels.values().stream().map(ch -> CompletableFuture.runAsync(() -> ch.onViewChanged(newView), pool)).collect(Collectors.toList());
        }
        Task.allOf(tasks).join();
    }

    public Task<Void> sendMessage(NodeAddress from, NodeAddress to, byte[] buff) {
        if (to == null) {
            throw new NullPointerException("Target address cannot be null");
        }
        return Task.runAsync(() -> {
            try {
                FakeClusterPeer fakeClusterPeer = this.currentChannels.get(to);
                if (fakeClusterPeer == null) {
                    throw new UncheckedException("Unknown address: " + to);
                }
                fakeClusterPeer.onMessageReceived(from, buff);
            }
            catch (Exception ex) {
                logger.error("Error sending message", (Throwable)ex);
            }
        }, (Executor)pool);
    }

    public static FakeGroup get(String clusterName) {
        return (FakeGroup)groups.get((Object)clusterName);
    }

    public <K, V> DistributedMap<K, V> getCache(final String name) {
        return new DistributedMap(){
            final ConcurrentMap map;
            {
                this.map = (ConcurrentMap)FakeGroup.this.maps.get((Object)name);
            }

            public Task putIfAbsent(Object key, Object value) {
                return Task.fromValue((Object)this.map.putIfAbsent(key, value));
            }

            public Task put(Object key, Object value) {
                return Task.fromValue((Object)this.map.put(key, value));
            }

            public Task get(Object key) {
                return Task.fromValue(this.map.get(key));
            }

            public Task<Boolean> remove(Object key, Object value) {
                return Task.fromValue((Object)this.map.remove(key, value));
            }
        };
    }

    public Map<String, ConcurrentMap> getCaches() {
        return this.maps.asMap();
    }

    Executor pool() {
        return pool;
    }
}

