/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class FakeClock
extends Clock {
    private AtomicLong millis = new AtomicLong(System.currentTimeMillis());
    private ZoneId zoneId = Clock.systemUTC().getZone();
    private boolean stopped;

    @Override
    public ZoneId getZone() {
        return this.zoneId;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        FakeClock clock = new FakeClock();
        clock.millis.set(this.millis.get());
        clock.zoneId = zone;
        return clock;
    }

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(this.millis());
    }

    @Override
    public long millis() {
        if (this.stopped) {
            return this.millis.get();
        }
        return System.currentTimeMillis();
    }

    public long incrementTimeMillis(long offsetMillis) {
        return this.millis.addAndGet(offsetMillis);
    }

    public long incrementTime(long time, TimeUnit timeUnit) {
        return this.incrementTimeMillis(timeUnit.toMillis(time));
    }

    public void stop() {
        this.stopped = true;
        this.millis.set(Math.max(System.currentTimeMillis(), this.millis.get()));
    }
}

