/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import cloud.orbit.tuples.Pair;
import java.util.Queue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Singleton;

@Singleton
public class FakeSync {
    private LoadingMap<Object, Task> tasks = new LoadingMap(Task::new);
    private LoadingMap<String, UncheckedSemaphore> semaphores = new LoadingMap(() -> new UncheckedSemaphore(0));
    private LoadingMap<String, BlockingDeque> deques = new LoadingMap(LinkedBlockingDeque::new);
    private LoadingMap<String, CompletableFuture> futures = new LoadingMap(CompletableFuture::new);
    private Queue<Pair<CompletableFuture, Object>> blockedFutures = new ConcurrentLinkedQueue<Pair<CompletableFuture, Object>>();

    public <T> Task<T> futureFrom(Supplier<Task<T>> supplier) {
        return supplier.get();
    }

    public <T> CompletableFuture<T> getBlockedFuture(T value) {
        CompletableFuture future = new CompletableFuture();
        this.blockedFutures.add((Pair<CompletableFuture, Object>)Pair.of(future, value));
        return future;
    }

    public <T> CompletableFuture<T> getBlockedFuture() {
        return this.getBlockedFuture(null);
    }

    public <T> Task<T> getBlockedTask(T value) {
        Task future = new Task();
        this.blockedFutures.add((Pair<CompletableFuture, Object>)Pair.of((Object)future, value));
        return future;
    }

    public <T> Task<T> getBlockedTask() {
        return this.getBlockedTask(null);
    }

    public void completeFutures() {
        while (this.blockedFutures.size() > 0) {
            Pair<CompletableFuture, Object> pair = this.blockedFutures.poll();
            if (pair == null) continue;
            ((CompletableFuture)pair.getLeft()).complete(pair.getRight());
        }
    }

    public int blockedFutureCount() {
        return this.blockedFutures.size();
    }

    @Deprecated
    public void put(Object key, Object value) {
        this.get(key).complete(value);
    }

    @Deprecated
    public <T> Task<T> get(Object key) {
        Task t = (Task)this.tasks.get(key);
        if (t == null) {
            this.tasks.putIfAbsent(key, new Task());
            t = (Task)this.tasks.get(key);
        }
        return t;
    }

    public UncheckedSemaphore semaphore(String semaphoreName) {
        return this.semaphores.getOrAdd(semaphoreName);
    }

    public <T> Task<T> task(String name) {
        return this.tasks.getOrAdd(name);
    }

    public <T> CompletableFuture<T> future(String name) {
        return this.futures.getOrAdd(name);
    }

    public <T> BlockingDeque<T> deque(String name) {
        return this.deques.getOrAdd(name);
    }

    public static class UncheckedSemaphore
    extends Semaphore {
        private UncheckedSemaphore(int permits) {
            super(permits);
        }

        @Override
        public void acquire() {
            try {
                super.acquire();
            }
            catch (InterruptedException e) {
                throw new UncheckedException((Throwable)e);
            }
        }

        @Override
        public void acquire(int permits) {
            try {
                super.acquire(permits);
            }
            catch (InterruptedException e) {
                throw new UncheckedException((Throwable)e);
            }
        }

        public void acquire(long timeout, TimeUnit unit) {
            try {
                if (!super.tryAcquire(timeout, unit)) {
                    throw new UncheckedException("timeout");
                }
            }
            catch (InterruptedException e) {
                throw new UncheckedException((Throwable)e);
            }
        }

        @Override
        public boolean tryAcquire(long timeout, TimeUnit unit) {
            try {
                return super.tryAcquire(timeout, unit);
            }
            catch (InterruptedException e) {
                throw new UncheckedException((Throwable)e);
            }
        }

        @Override
        public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
            try {
                return super.tryAcquire(permits, timeout, unit);
            }
            catch (InterruptedException e) {
                throw new UncheckedException((Throwable)e);
            }
        }
    }

    private static class LoadingMap<K, V>
    extends ConcurrentHashMap<K, V> {
        private Supplier<V> supplier;

        public LoadingMap(Supplier<V> supplier) {
            this.supplier = supplier;
        }

        public V getOrAdd(K key) {
            Object value = this.get(key);
            if (value == null) {
                V newValue = this.supplier.get();
                V oldValue = this.putIfAbsent(key, newValue);
                return oldValue != null ? oldValue : newValue;
            }
            return value;
        }
    }
}

