/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.actors.cluster.ClusterPeer;
import cloud.orbit.actors.cluster.MessageListener;
import cloud.orbit.actors.cluster.NodeAddress;
import cloud.orbit.actors.cluster.ViewListener;
import cloud.orbit.actors.test.FakeGroup;
import cloud.orbit.concurrent.Task;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class FakeClusterPeer
implements ClusterPeer {
    private ViewListener viewListener;
    private MessageListener messageListener;
    private FakeGroup group;
    private NodeAddress address;
    private AtomicLong messagesSent = new AtomicLong();
    private AtomicLong messagesSentOk = new AtomicLong();
    private AtomicLong messagesReceived = new AtomicLong();
    private AtomicLong messagesReceivedOk = new AtomicLong();
    private CompletableFuture<?> startFuture = new CompletableFuture();

    public Task<Void> join(String clusterName, String nodeName) {
        this.group = FakeGroup.get(clusterName);
        return Task.runAsync(() -> {
            this.address = this.group.join(this);
            this.startFuture.complete(null);
        }, (Executor)this.group.pool());
    }

    public void leave() {
        this.group.leave(this);
    }

    public void onViewChanged(List<NodeAddress> newView) {
        this.viewListener.onViewChange(newView);
    }

    public void onMessageReceived(NodeAddress from, byte[] buff) {
        this.messagesReceived.incrementAndGet();
        this.messageListener.receive(from, buff);
        this.messagesReceivedOk.incrementAndGet();
    }

    public NodeAddress localAddress() {
        return this.address;
    }

    public void registerViewListener(ViewListener viewListener) {
        this.viewListener = viewListener;
    }

    public void registerMessageReceiver(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void sendMessage(NodeAddress to, byte[] message) {
        this.startFuture.join();
        this.messagesSent.incrementAndGet();
        this.group.sendMessage(this.address, to, message).thenRun(() -> this.messagesSentOk.incrementAndGet());
    }

    public <K, V> ConcurrentMap<K, V> getCache(String name) {
        return this.group.getCache(name);
    }

    void setAddress(NodeAddress address) {
        this.address = address;
    }
}

