/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.actors.extensions.LifetimeExtension;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.actors.runtime.ReminderController;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.actors.test.TestLogger;
import cloud.orbit.concurrent.Task;

public class TestLifecycleLog
implements LifetimeExtension {
    private TestLogger logger;
    private String name;

    public TestLifecycleLog(TestLogger logger, String name) {
        this.logger = logger;
        this.name = name;
    }

    public Task<?> preActivation(AbstractActor<?> actor) {
        if (actor instanceof ReminderController) {
            return Task.done();
        }
        String to = this.toString(actor);
        this.logger.sequenceDiagram.add("hnote over \"" + to + "\" #white : [" + this.name + "] activate");
        return Task.done();
    }

    public Task<?> postDeactivation(AbstractActor<?> actor) {
        if (actor instanceof ReminderController) {
            return Task.done();
        }
        String to = this.toString(actor);
        this.logger.sequenceDiagram.add("hnote over \"" + to + "\" #white : [" + this.name + "] deactivate");
        return Task.done();
    }

    String toString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof AbstractActor) {
            RemoteReference ref = RemoteReference.from((AbstractActor)((AbstractActor)obj));
            return RemoteReference.getInterfaceClass((RemoteReference)ref).getSimpleName() + ":" + RemoteReference.getId((RemoteReference)ref);
        }
        if (obj instanceof RemoteReference) {
            return RemoteReference.getInterfaceClass((RemoteReference)((RemoteReference)obj)).getSimpleName() + ":" + RemoteReference.getId((RemoteReference)((RemoteReference)obj));
        }
        return String.valueOf(obj);
    }
}

