/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.actors.Actor;
import cloud.orbit.actors.Remindable;
import cloud.orbit.actors.Stage;
import cloud.orbit.actors.extensions.ActorExtension;
import cloud.orbit.actors.extensions.StorageExtension;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.actors.runtime.TickStatus;
import cloud.orbit.actors.test.ActorBaseTest;
import cloud.orbit.actors.test.FakeSync;
import cloud.orbit.actors.test.StorageTest;
import cloud.orbit.actors.test.StorageTestState;
import cloud.orbit.concurrent.Task;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class StorageBaseTest
extends ActorBaseTest {
    @Test
    public void checkWritesTest() throws Exception {
        Stage stage = this.createStage();
        Assert.assertEquals((long)0L, (long)this.count());
        StorageTest helloActor = (StorageTest)Actor.getReference(this.getActorInterfaceClass(), (String)"300");
        helloActor.sayHello("Meep Meep").join();
        Assert.assertEquals((long)1L, (long)this.count());
    }

    @Test
    public void heavyTest() throws Exception {
        StorageTest helloActor;
        String id;
        int t;
        Stage stage = this.createStage();
        Assert.assertEquals((long)0L, (long)this.count());
        for (t = 0; t < this.heavyTestSize(); ++t) {
            id = "" + t;
            helloActor = (StorageTest)Actor.getReference(this.getActorInterfaceClass(), (String)id);
            helloActor.sayHello("Meep Meep" + t).join();
        }
        Assert.assertEquals((long)this.heavyTestSize(), (long)this.count());
        for (t = 0; t < this.heavyTestSize(); ++t) {
            id = "" + t;
            helloActor = (StorageTest)Actor.getReference(this.getActorInterfaceClass(), (String)id);
            helloActor.sayHello("Meep Meep" + t).join();
            Assert.assertEquals((Object)this.readState(id).lastName(), (Object)("Meep Meep" + t));
        }
        for (t = 0; t < this.heavyTestSize(); ++t) {
            id = "" + t;
            helloActor = (StorageTest)Actor.getReference(this.getActorInterfaceClass(), (String)id);
            helloActor.clear().join();
        }
        Assert.assertEquals((long)0L, (long)this.count());
    }

    @Test
    public void checkReadTest() throws Exception {
        Stage stage = this.createStage();
        StorageTest helloActor = (StorageTest)Actor.getReference(this.getActorInterfaceClass(), (String)"300");
        helloActor.sayHello("Meep Meep").join();
        Assert.assertEquals((Object)this.readState("300").lastName(), (Object)"Meep Meep");
    }

    @Test
    public void checkClearTest() throws Exception {
        Stage stage = this.createStage();
        Assert.assertEquals((long)0L, (long)this.count());
        StorageTest helloActor1 = (StorageTest)Actor.getReference(this.getActorInterfaceClass(), (String)"300");
        helloActor1.sayHello("Meep Meep").join();
        StorageTest helloActor2 = (StorageTest)Actor.getReference(this.getActorInterfaceClass(), (String)"301");
        helloActor2.sayHello("Meep Meep").join();
        Assert.assertEquals((long)2L, (long)this.count());
        helloActor1.clear().join();
        Assert.assertEquals((long)1L, (long)this.count());
        helloActor2.clear().join();
        Assert.assertEquals((long)0L, (long)this.count());
    }

    @Test
    public void checkUpdateTest() throws Exception {
        Stage stage = this.createStage();
        Assert.assertEquals((long)0L, (long)this.count());
        StorageTest helloActor = (StorageTest)Actor.getReference(this.getActorInterfaceClass(), (String)"300");
        helloActor.sayHello("Meep Meep").join();
        Assert.assertEquals((long)1L, (long)this.count());
        helloActor.sayHello("Peem Peem").join();
        Assert.assertEquals((Object)this.readState("300").lastName(), (Object)"Peem Peem");
    }

    @Test(timeout=30000L)
    public void checkReminderTest() throws Exception {
        this.createStage();
        Assert.assertEquals((long)0L, (long)this.count());
        Timed actor = (Timed)Actor.getReference(Timed.class, (String)"999");
        actor.startReminder().join();
        this.fakeSync.semaphore("reminderReceived").tryAcquire(1, 10L, TimeUnit.SECONDS);
    }

    @Override
    protected void installExtensions(Stage stage) {
        stage.getExtensions().removeAll(stage.getAllExtensions(StorageExtension.class));
        stage.addExtension(this.getStorageExtension());
    }

    @Before
    public void setup() throws Exception {
        this.initStorage();
    }

    @Override
    @After
    public void after() {
        super.after();
        this.closeStorage();
    }

    public abstract Class<? extends StorageTest> getActorInterfaceClass();

    public abstract ActorExtension getStorageExtension();

    public abstract void initStorage();

    public abstract void closeStorage();

    public abstract long count();

    public abstract int heavyTestSize();

    public abstract StorageTestState readState(String var1);

    public static class TimedActor
    extends AbstractActor
    implements Timed {
        @Inject
        FakeSync sync;

        @Override
        public Task<Void> startReminder() {
            this.registerReminder("hey", 1L, 1L, TimeUnit.SECONDS);
            return Task.done();
        }

        public Task<?> receiveReminder(String reminderName, TickStatus status) {
            this.unregisterReminder("hey");
            this.sync.semaphore("reminderReceived").release(1);
            return Task.done();
        }
    }

    public static interface Timed
    extends Actor,
    Remindable {
        public Task<Void> startReminder();
    }
}

