/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.actors.net.HandlerAdapter;
import cloud.orbit.actors.net.HandlerContext;
import cloud.orbit.concurrent.Task;
import java.util.concurrent.Executor;

public class ShortCircuitHandler
extends HandlerAdapter {
    private HandlerContext firstCtx;
    private HandlerContext secondCtx;
    private Executor executor;

    public void onRegistered(HandlerContext ctx) throws Exception {
        if (ctx != this.firstCtx && ctx != this.secondCtx) {
            if (this.firstCtx == null) {
                this.firstCtx = ctx;
            } else if (this.secondCtx == null) {
                this.secondCtx = ctx;
            } else {
                throw new IllegalStateException("onRegistered called with more than 2 different contexts!");
            }
        }
    }

    public Task write(HandlerContext ctx, Object msg) throws Exception {
        if (ctx == this.firstCtx) {
            this.executor.execute(() -> this.secondCtx.fireRead(msg));
        } else {
            this.executor.execute(() -> this.firstCtx.fireRead(msg));
        }
        return Task.done();
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

