/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.actors.Actor;
import cloud.orbit.actors.extensions.DefaultLoggerExtension;
import cloud.orbit.actors.extensions.LoggerExtension;
import cloud.orbit.actors.net.Handler;
import cloud.orbit.actors.peer.PeerExtension;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.actors.test.LogInterceptor;
import cloud.orbit.concurrent.ConcurrentHashSet;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class TestLogger
implements LoggerExtension,
PeerExtension {
    private String nodeId = "";
    private final DefaultLoggerExtension defaultLogger = new DefaultLoggerExtension();
    private final ConcurrentHashSet<Object> classesToDebug;
    private final StringBuilder logText;
    protected final List<String> sequenceDiagram;
    private boolean visible;

    public TestLogger() {
        this.classesToDebug = new ConcurrentHashSet();
        this.logText = new StringBuilder();
        this.sequenceDiagram = Collections.synchronizedList(new ArrayList());
    }

    public TestLogger(TestLogger parentLogger, String nodeId) {
        this.classesToDebug = parentLogger.classesToDebug;
        this.sequenceDiagram = parentLogger.sequenceDiagram;
        this.logText = parentLogger.logText;
        this.nodeId = nodeId;
    }

    public Logger getLogger(Object object) {
        String target;
        Class<?> targetClass;
        final Logger logger = this.defaultLogger.getLogger(object);
        Class<?> clazz = object == null ? null : (object instanceof String ? null : (targetClass = object instanceof Class ? (Class<?>)object : object.getClass()));
        if (object instanceof Actor) {
            RemoteReference reference = RemoteReference.from((Actor)((Actor)object));
            target = (RemoteReference.getInterfaceClass((RemoteReference)reference).getSimpleName() + ":" + RemoteReference.getId((RemoteReference)reference)).replaceAll("[\"\\t\\r\\n]", "");
        } else {
            target = object instanceof Handler ? object.getClass().getSimpleName() + ":" + object.hashCode() : logger.getName();
        }
        return new LogInterceptor(logger){

            @Override
            public boolean isErrorEnabled() {
                if (targetClass != null && TestLogger.this.classesToDebug.contains((Object)targetClass)) {
                    return true;
                }
                return super.isErrorEnabled();
            }

            @Override
            public boolean isDebugEnabled() {
                if (targetClass != null && TestLogger.this.classesToDebug.contains((Object)targetClass)) {
                    return true;
                }
                return super.isDebugEnabled();
            }

            @Override
            public boolean isWarnEnabled() {
                if (targetClass != null && TestLogger.this.classesToDebug.contains((Object)targetClass)) {
                    return true;
                }
                return super.isWarnEnabled();
            }

            @Override
            public boolean isInfoEnabled() {
                if (targetClass != null && TestLogger.this.classesToDebug.contains((Object)targetClass)) {
                    return true;
                }
                return super.isInfoEnabled();
            }

            @Override
            protected void message(String type, Marker marker, String format, Object ... arguments) {
                String fmtMessage = format;
                if (arguments != null && arguments.length > 0) {
                    try {
                        fmtMessage = MessageFormatter.format((String)format, (Object)arguments).getMessage();
                    }
                    catch (Exception ex) {
                        logger.error("Error formatting message: {}", (Object)format);
                        fmtMessage = "Error formatting message: " + format;
                    }
                }
                String message = (!"info".equalsIgnoreCase(type) ? type + ": " : "") + fmtMessage;
                TestLogger.this.write(type + " " + new Date() + " " + target + " " + message);
                String position = "over";
                TestLogger.this.note(position, target, message);
            }
        };
    }

    public synchronized void write(CharSequence buffer) {
        if ((double)this.logText.length() > 2.5E8) {
            this.logText.setLength(64000);
            this.logText.append("The log was truncated!").append("\r\n");
        }
        this.logText.append(buffer).append("\r\n");
        if (this.visible) {
            System.out.println(buffer);
        }
    }

    private void note(String position, String target, String message) {
        StringBuilder note = new StringBuilder("note ");
        note.append(position).append(" \"").append(target).append('\"');
        if (message.contains("\n")) {
            note.append("\r\n");
            note.append(TestLogger.wrap(message, 40, "\r\n", true));
            note.append("\r\n").append("end note");
        } else {
            note.append(": ").append(message);
        }
        this.sequenceDiagram.add(note.toString());
    }

    public void enableDebugFor(Class clazz) {
        this.classesToDebug.add((Object)clazz);
    }

    public void disableDebugFor(Class clazz) {
        this.classesToDebug.add((Object)clazz);
    }

    public void disableDebugForAll() {
        this.classesToDebug.clear();
    }

    static String wrap(String str, int width, String lineBreak, boolean breakWords) {
        int length = str.length();
        if (length < width) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int pos = 0;
        while (length - start > width) {
            int possibleBreak = -1;
            while (pos - start < width && pos < length) {
                char ch = str.charAt(pos);
                if (!Character.isDigit(ch) && !Character.isAlphabetic(ch)) {
                    possibleBreak = pos;
                }
                ++pos;
            }
            if (possibleBreak > 0) {
                sb.append(str, start, possibleBreak + 1);
                start = possibleBreak + 1;
            } else {
                sb.append(str, start, pos);
                start = pos;
            }
            if (start >= length) continue;
            sb.append(lineBreak);
        }
        if (start < length) {
            sb.append(str, start, length);
        }
        return sb.toString();
    }

    public void clear() {
        this.sequenceDiagram.clear();
    }

    public CharSequence getLogText() {
        return this.logText;
    }

    public void addToSequenceDiagram(String sequenceEntry) {
        this.sequenceDiagram.add(sequenceEntry);
    }

    public void dumpMessages(String fileName) {
        PrintStream out = System.out;
        if (this.sequenceDiagram.size() > 0) {
            Path seqUml = Paths.get(fileName, new String[0]);
            try {
                Files.createDirectories(seqUml.getParent(), new FileAttribute[0]);
                Files.write(seqUml, (Iterable<? extends CharSequence>)Stream.concat(Stream.concat(Stream.of("@startuml"), Stream.of(this.sequenceDiagram.toArray()).map(o -> (String)o)), Stream.of("@enduml")).collect(Collectors.toList()), new OpenOption[0]);
                out.println(seqUml.toUri());
            }
            catch (Exception ex) {
                new IOException("error dumping messages: " + ex.getMessage(), ex).printStackTrace();
            }
        } else {
            out.println("No messages to dump!");
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

