/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.actors.extensions.NamedPipelineExtension;
import cloud.orbit.actors.net.HandlerContext;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.actors.runtime.DefaultClassDictionary;
import cloud.orbit.actors.runtime.DefaultDescriptorFactory;
import cloud.orbit.actors.runtime.Message;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.actors.test.TestLogger;
import cloud.orbit.actors.test.TestUtils;
import cloud.orbit.concurrent.Task;
import cloud.orbit.tuples.Pair;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;

public class TestMessageLog
extends NamedPipelineExtension {
    private TestLogger logger;
    private String name;

    public TestMessageLog(TestLogger logger) {
        this(logger, "test-message-logging", null, "messaging");
    }

    public TestMessageLog(TestLogger logger, String name) {
        this(logger, name, null, "messaging");
    }

    public TestMessageLog(TestLogger logger, String name, String beforeHandlerName, String afterHandlerName) {
        super(name, beforeHandlerName, afterHandlerName);
        this.logger = logger;
        this.name = name;
    }

    public void onRead(HandlerContext ctx, Object msg) {
        if (msg instanceof Message) {
            this.logMessage((Message)msg, true);
        } else if (msg instanceof Pair) {
            this.logBytes((Pair<Object, byte[]>)((Pair)msg));
        }
        ctx.fireRead(msg);
    }

    public Task write(HandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Message) {
            this.logMessage((Message)msg, false);
        } else if (msg instanceof Pair) {
            this.logBytes((Pair<Object, byte[]>)((Pair)msg));
        }
        return ctx.write(msg);
    }

    private void logBytes(Pair<Object, byte[]> pair) {
        ObjectMapper objectMapper = new ObjectMapper();
        String buffer = new String((byte[])pair.getRight(), 4, ((byte[])pair.getRight()).length - 4, StandardCharsets.UTF_8);
        this.logger.write(buffer);
        try {
            this.logger.write(objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(objectMapper.readValue(buffer, Object.class)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.write(TestUtils.hexDump(32, (byte[])pair.getRight(), 0, ((byte[])pair.getRight()).length));
    }

    private void logMessage(Message message, boolean in) {
        Class clazz;
        String from;
        long messageId = message.getMessageId();
        String string = message.getFromNode() != null ? String.valueOf(message.getFromNode().asUUID().getLeastSignificantBits()) : (from = in ? "IN" : "OUT");
        String to = message.getToNode() != null ? String.valueOf(message.getToNode().asUUID().getLeastSignificantBits()) : (in ? "OUT" : "IN");
        String strParams = "";
        Object payload = message.getPayload();
        if (payload instanceof Object[]) {
            Object[] params = (Object[])payload;
            if (params.length > 0) {
                try {
                    strParams = Arrays.asList(params).stream().map(a -> this.toString(a)).collect(Collectors.joining(", ", "(", ")"));
                }
                catch (Exception ex) {
                    strParams = "(can't show parameters)";
                }
            }
        } else {
            strParams = payload != null ? String.valueOf(payload) : "";
        }
        String strTarget = "";
        if (message.getInterfaceId() != 0 && (clazz = DefaultClassDictionary.get().getClassById(message.getInterfaceId())) != null) {
            Method method = DefaultDescriptorFactory.get().getInvoker(clazz).getMethod(message.getMethodId());
            strTarget = clazz.getSimpleName() + ":" + message.getObjectId() + "." + method.getName();
        }
        String seqMsg = '\"' + from + "\" -> \"" + to + "\" : [" + this.name + ":" + messageId + "] " + strTarget + " " + strParams;
        this.logger.sequenceDiagram.add(seqMsg);
        while (this.logger.sequenceDiagram.size() > 100) {
            this.logger.sequenceDiagram.remove(0);
        }
        this.logger.write(seqMsg);
    }

    String toString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof AbstractActor) {
            RemoteReference ref = RemoteReference.from((AbstractActor)((AbstractActor)obj));
            return RemoteReference.getInterfaceClass((RemoteReference)ref).getSimpleName() + ":" + RemoteReference.getId((RemoteReference)ref);
        }
        if (obj instanceof RemoteReference) {
            return RemoteReference.getInterfaceClass((RemoteReference)((RemoteReference)obj)).getSimpleName() + ":" + RemoteReference.getId((RemoteReference)((RemoteReference)obj));
        }
        return String.valueOf(obj);
    }
}

