/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.actors.extensions.PipelineExtension;
import cloud.orbit.actors.net.HandlerContext;
import cloud.orbit.actors.peer.PeerExtension;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.actors.runtime.ActorTaskContext;
import cloud.orbit.actors.runtime.DefaultDescriptorFactory;
import cloud.orbit.actors.runtime.Invocation;
import cloud.orbit.actors.runtime.NodeCapabilities;
import cloud.orbit.actors.runtime.ReminderController;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.actors.test.ActorBaseTest;
import cloud.orbit.actors.test.TestLogger;
import cloud.orbit.concurrent.Task;
import cloud.orbit.concurrent.TaskContext;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class TestInvocationLog
implements PipelineExtension,
PeerExtension {
    private AtomicLong invocationId = new AtomicLong();
    private TestLogger logger;
    private String name;

    public TestInvocationLog(TestLogger logger) {
        this(logger, "");
    }

    public TestInvocationLog(TestLogger logger, String name) {
        this.logger = logger;
        this.name = name;
    }

    public String getName() {
        return "test-invocation-logging";
    }

    public String getAfterHandlerName() {
        return "head";
    }

    String toString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof AbstractActor) {
            RemoteReference ref = RemoteReference.from((AbstractActor)((AbstractActor)obj));
            return RemoteReference.getInterfaceClass((RemoteReference)ref).getSimpleName() + ":" + RemoteReference.getId((RemoteReference)ref);
        }
        if (obj instanceof RemoteReference) {
            return RemoteReference.getInterfaceClass((RemoteReference)((RemoteReference)obj)).getSimpleName() + ":" + RemoteReference.getId((RemoteReference)((RemoteReference)obj));
        }
        return String.valueOf(obj);
    }

    public Task<?> write(HandlerContext ctx, Object message) {
        String strParams;
        if (!(message instanceof Invocation)) {
            return ctx.write(message);
        }
        Invocation invocation = (Invocation)message;
        long id = this.invocationId.incrementAndGet();
        RemoteReference toReference = invocation.getToReference();
        if (toReference instanceof NodeCapabilities) {
            return ctx.write(message);
        }
        Method method = invocation.getMethod();
        if (method == null) {
            method = DefaultDescriptorFactory.get().getInvoker(RemoteReference.getInterfaceClass((RemoteReference)toReference)).getMethod(invocation.getMethodId());
        }
        String methodName = method.getName();
        if (toReference instanceof ReminderController && "ensureStart".equals(methodName)) {
            return ctx.write(message);
        }
        String from = TestLogger.wrap(this.getFrom(toReference, method), 32, "\\n", false);
        String to = TestLogger.wrap(RemoteReference.getInterfaceClass((RemoteReference)toReference).getSimpleName() + ":" + RemoteReference.getId((RemoteReference)toReference), 32, "\\n", false);
        Object[] params = invocation.getParams();
        if (params != null && params.length > 0) {
            try {
                strParams = Arrays.asList(params).stream().map(a -> this.toString(a)).collect(Collectors.joining(", ", "(", ")"));
                strParams = TestLogger.wrap(strParams, 30, "\\n", true);
            }
            catch (Exception ex) {
                strParams = "(can't show parameters)";
            }
        } else {
            strParams = "";
        }
        if (invocation.getHeaders() != null) {
            strParams = strParams + " " + invocation.getHeaders();
        }
        if (!invocation.isOneWay()) {
            String msg = '\"' + from + "\" -> \"" + to + "\" : [" + this.name + ":m" + id + "] " + methodName + strParams + "\r\n" + "activate \"" + to + "\"";
            this.logger.sequenceDiagram.add(msg);
            while (this.logger.sequenceDiagram.size() > 100) {
                this.logger.sequenceDiagram.remove(0);
            }
            this.logger.write(msg);
            long start = System.nanoTime();
            Task write = ctx.write(message);
            return write.whenComplete((r, e) -> {
                long timeUS = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - start);
                String timeStr = NumberFormat.getNumberInstance(Locale.US).format(timeUS);
                if (e == null) {
                    String resp = '\"' + to + "\" --> \"" + from + "\" : [" + this.name + ":r" + id + "; " + timeStr + "us] " + TestLogger.wrap("(response to " + methodName + "): " + this.toString(r), 32, "\\n", true) + "\r\n" + "deactivate \"" + to + "\"";
                    this.logger.sequenceDiagram.add(resp);
                    this.logger.write(resp);
                } else {
                    Throwable throwable = this.unwrapException((Throwable)e);
                    String resp = '\"' + to + "\" --> \"" + from + "\" : [" + this.name + ":r" + id + "; " + timeStr + "us] (exception at " + methodName + "):\\n" + throwable.getClass().getName() + (throwable.getMessage() != null ? ": \\n" + throwable.getMessage() : "") + "\r\n" + "deactivate \"" + to + "\"";
                    this.logger.sequenceDiagram.add(resp);
                    this.logger.write(resp);
                }
            });
        }
        String msg = '\"' + from + "\" -> \"" + to + "\" : [" + id + "] " + methodName + strParams;
        this.logger.sequenceDiagram.add(msg);
        this.logger.write('\"' + from + "\" -> \"" + to + "\" : [" + id + "] " + methodName + strParams);
        return ctx.write(message);
    }

    private Throwable unwrapException(Throwable e) {
        Throwable ex = e;
        while (ex.getCause() != null && ex instanceof CompletionException) {
            ex = ex.getCause();
        }
        return ex;
    }

    private String getFrom(RemoteReference reference, Method method) {
        String from;
        ActorTaskContext context = ActorTaskContext.current();
        if (context != null && context.getActor() != null) {
            RemoteReference contextReference = RemoteReference.from((AbstractActor)context.getActor());
            from = RemoteReference.getInterfaceClass((RemoteReference)contextReference).getSimpleName() + ":" + RemoteReference.getId((RemoteReference)contextReference);
        } else {
            TaskContext current;
            from = reference != null && RemoteReference.getInterfaceClass((RemoteReference)reference) == NodeCapabilities.class && method.getName().equals("canActivate") ? "Stage" : ((current = TaskContext.current()) != null && current.getProperty(ActorBaseTest.TEST_NAME_PROP) != null ? String.valueOf(current.getProperty(ActorBaseTest.TEST_NAME_PROP)) : "Thread:" + Thread.currentThread().getId());
        }
        return from;
    }
}

