/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.actors.Actor;
import cloud.orbit.actors.Stage;
import cloud.orbit.actors.client.ClientPeer;
import cloud.orbit.actors.cloner.ExecutionObjectCloner;
import cloud.orbit.actors.cloner.KryoCloner;
import cloud.orbit.actors.cluster.ClusterPeer;
import cloud.orbit.actors.concurrent.MultiExecutionSerializer;
import cloud.orbit.actors.concurrent.WaitFreeExecutionSerializer;
import cloud.orbit.actors.extensions.ActorExtension;
import cloud.orbit.actors.extensions.LifetimeExtension;
import cloud.orbit.actors.extensions.MessageSerializer;
import cloud.orbit.actors.extensions.json.InMemoryJSONStorageExtension;
import cloud.orbit.actors.extensions.json.JsonMessageSerializer;
import cloud.orbit.actors.net.Handler;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.actors.runtime.AbstractExecution;
import cloud.orbit.actors.runtime.ActorFactoryGenerator;
import cloud.orbit.actors.runtime.ActorTaskContext;
import cloud.orbit.actors.runtime.Execution;
import cloud.orbit.actors.runtime.NodeCapabilities;
import cloud.orbit.actors.server.ServerPeer;
import cloud.orbit.actors.test.FakeClient;
import cloud.orbit.actors.test.FakeClock;
import cloud.orbit.actors.test.FakeClusterPeer;
import cloud.orbit.actors.test.FakeServerPeer;
import cloud.orbit.actors.test.FakeSync;
import cloud.orbit.actors.test.ShortCircuitHandler;
import cloud.orbit.actors.test.TestInvocationLog;
import cloud.orbit.actors.test.TestLifecycleLog;
import cloud.orbit.actors.test.TestLogger;
import cloud.orbit.concurrent.ExecutorUtils;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import com.google.common.util.concurrent.ForwardingExecutorService;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;

public class ActorBaseTest {
    static final String TEST_NAME_PROP = ActorBaseTest.class.getName() + ".testName";
    protected TestLogger loggerExtension = new TestLogger();
    protected Logger logger = this.loggerExtension.getLogger(this.getClass());
    protected String clusterName = "cluster." + Math.random() + "." + this.getClass().getSimpleName();
    protected FakeClock clock = new FakeClock(){

        @Override
        public long incrementTime(long time, TimeUnit timeUnit) {
            return super.incrementTime(time, timeUnit);
        }
    };
    protected ConcurrentHashMap<Object, Object> fakeDatabase = new ConcurrentHashMap();
    protected List<Stage> stages = new ArrayList<Stage>();
    protected List<FakeClient> clients = new ArrayList<FakeClient>();
    protected List<ServerPeer> serversConnections = new ArrayList<ServerPeer>();
    protected Description testDescription;
    protected ServiceLocator serviceLocator;
    protected static final ExecutorService commonPool = new ForwardingExecutorService(){
        ExecutorService delegate = ExecutorUtils.newScalingThreadPool((int)200);

        protected ExecutorService delegate() {
            return this.delegate;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        public void shutdown() {
            try {
                this.delegate.awaitTermination(0L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new UncheckedException((Throwable)e);
            }
        }
    };
    protected FakeSync fakeSync = new FakeSync();
    @Rule
    public TestRule dumpLogs = new TestWatcher(){
        final ActorTaskContext taskContext = new ActorTaskContext();

        protected void starting(Description description) {
            ActorBaseTest.this.logger = ActorBaseTest.this.loggerExtension.getLogger(description.getMethodName());
            this.taskContext.push();
            this.taskContext.setProperty(TEST_NAME_PROP, (Object)description.getMethodName());
            this.taskContext.setProperty(ActorBaseTest.class.getName(), (Object)description);
            ActorBaseTest.this.testDescription = description;
        }

        protected void finished(Description description) {
            try {
                this.taskContext.pop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void succeeded(Description description) {
            ActorBaseTest.this.loggerExtension.clear();
            ActorBaseTest.this.fakeDatabase.clear();
        }

        protected void failed(Throwable e, Description description) {
            PrintStream out = System.out;
            out.println(">>>>>>>>> Start");
            out.println(">>>>>>>>> Test Dump for " + description);
            out.println(">>>>>>>>> Error: " + e);
            out.println(ActorBaseTest.this.loggerExtension.getLogText());
            out.println(">>>>>>>>> Test Dump for " + description);
            out.print(">>>>>>>>> Error: ");
            e.printStackTrace(out);
            out.println(">>>>>>>>> Stages: " + ActorBaseTest.this.stages.size());
            ActorBaseTest.this.stages.forEach(s -> out.println("    " + s));
            out.println(">>>>>>>>> Clients: " + ActorBaseTest.this.clients.size());
            ActorBaseTest.this.clients.forEach(s -> out.println("    " + (Object)s));
            out.println(">>>>>>>>> Server Connections: " + ActorBaseTest.this.serversConnections.size());
            ActorBaseTest.this.serversConnections.forEach(s -> out.println("    " + s));
            out.println(">>>>>>>>> End");
            String name = description.getClassName();
            if (description != null && description.getMethodName() != null) {
                name = name + "-" + description.getMethodName();
            }
            out.println("Message sequence diagram written to:");
            ActorBaseTest.this.loggerExtension.dumpMessages("target/surefire-reports/" + name + "-error.messages.puml");
            ActorBaseTest.this.loggerExtension.clear();
            ActorBaseTest.this.fakeDatabase.clear();
        }
    };

    public ActorBaseTest() {
        ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
        this.serviceLocator = factory.create(UUID.randomUUID().toString());
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.serviceLocator, (Object)this.fakeSync);
    }

    @After
    public void after() {
        this.stages.clear();
    }

    protected void clearMessages() {
        this.loggerExtension.sequenceDiagram.clear();
    }

    protected void dumpMessages() {
        String name = this.getClass().getName();
        if (this.testDescription != null && this.testDescription.getMethodName() != null) {
            name = name + "-" + this.testDescription.getMethodName();
            StackTraceElement trace = Stream.of(new Exception().getStackTrace()).filter(x -> Objects.equals(x.getClassName(), this.testDescription.getClassName())).findFirst().orElse(null);
            PrintStream out = System.out;
            if (trace != null) {
                out.println("Message sequence diagram for " + trace);
            } else {
                out.println("Message sequence diagram written to:");
            }
        }
        this.loggerExtension.dumpMessages("target/surefire-reports/" + name + ".messages.puml");
    }

    public ClientPeer createRemoteClient(Stage stage) {
        JsonMessageSerializer serializer = new JsonMessageSerializer();
        ShortCircuitHandler network = new ShortCircuitHandler();
        network.setExecutor((Executor)new WaitFreeExecutionSerializer(commonPool));
        int connectionId = this.clients.size();
        FakeServerPeer serverPeer = new FakeServerPeer();
        serverPeer.setNetworkHandler((Handler)network);
        serverPeer.setClock(this.clock);
        serverPeer.setStage(stage);
        serverPeer.setMessageSerializer((MessageSerializer)serializer);
        serverPeer.addExtension(new TestLogger(this.loggerExtension, "sc" + connectionId));
        serverPeer.addExtension(new TestInvocationLog(this.loggerExtension, "sc" + connectionId));
        this.serversConnections.add(serverPeer);
        FakeClient fakeClient = new FakeClient();
        this.clients.add(fakeClient);
        fakeClient.setNetworkHandler((Handler)network);
        fakeClient.setClock(this.clock);
        fakeClient.setMessageSerializer((MessageSerializer)serializer);
        fakeClient.addExtension(new TestLogger(this.loggerExtension, "cc" + connectionId));
        fakeClient.addExtension(new TestInvocationLog(this.loggerExtension, "cc" + connectionId));
        serverPeer.start();
        fakeClient.start();
        return fakeClient;
    }

    public Stage createClient() {
        this.loggerExtension.write("Create Client");
        LifetimeExtension lifetimeExtension = new LifetimeExtension(){

            public Task<?> preActivation(AbstractActor<?> actor) {
                ActorBaseTest.this.serviceLocator.inject(actor);
                return Task.done();
            }
        };
        Stage client = new Stage.Builder().mode(Stage.StageMode.CLIENT).executionPool(commonPool).clock((Clock)this.clock).clusterName(this.clusterName).clusterPeer((ClusterPeer)new FakeClusterPeer()).extensions(new ActorExtension[]{lifetimeExtension}).build();
        this.installExtensions(client);
        client.start().join();
        client.bind();
        return client;
    }

    public Stage createStage() {
        this.loggerExtension.write("Create Stage");
        LifetimeExtension lifetimeExtension = new LifetimeExtension(){

            public Task<?> preActivation(AbstractActor<?> actor) {
                ActorBaseTest.this.serviceLocator.inject(actor);
                return Task.done();
            }
        };
        Stage stage = new Stage.Builder().extensions(new ActorExtension[]{lifetimeExtension, new InMemoryJSONStorageExtension(this.fakeDatabase)}).mode(Stage.StageMode.HOST).executionPool(commonPool).objectCloner(this.getExecutionObjectCloner()).clock((Clock)this.clock).clusterName(this.clusterName).clusterPeer((ClusterPeer)new FakeClusterPeer()).build();
        this.stages.add(stage);
        this.installExtensions(stage);
        stage.start().join();
        ActorFactoryGenerator afg = new ActorFactoryGenerator();
        Stream.of(this.getClass().getClasses()).forEach(c -> {
            if (Actor.class.isAssignableFrom((Class<?>)c) && c.isInterface()) {
                afg.getFactoryFor(c);
                stage.getHosting().canActivate(c.getName()).join();
            }
            if (AbstractActor.class.isAssignableFrom((Class<?>)c) && !Modifier.isAbstract(c.getModifiers())) {
                afg.getInvokerFor(c);
            }
        });
        stage.bind();
        return stage;
    }

    protected void installExtensions(Stage stage) {
        stage.addExtension((ActorExtension)new TestLogger(this.loggerExtension, "s" + this.stages.size()));
        stage.addExtension((ActorExtension)new TestInvocationLog(this.loggerExtension, "s" + this.stages.size()));
        stage.addExtension((ActorExtension)new TestLifecycleLog(this.loggerExtension, "s" + this.stages.size()));
    }

    protected ExecutionObjectCloner getExecutionObjectCloner() {
        return new KryoCloner();
    }

    public Throwable expectException(Exceptional callable) {
        try {
            Object r = callable.call();
            if (r instanceof Future) {
                ((Future)r).get(60L, TimeUnit.SECONDS);
            }
        }
        catch (Throwable ex) {
            return ex;
        }
        Assert.fail((String)"Was expecting some exception");
        return null;
    }

    private <T> T getField(Object target, Class<?> targetClazz, String name) throws IllegalAccessException, NoSuchFieldException {
        Field f = targetClazz.getDeclaredField(name);
        f.setAccessible(true);
        return (T)f.get(target);
    }

    protected void waitFor(Supplier<Boolean> condition) {
        try {
            while (!condition.get().booleanValue()) {
                Thread.sleep(20L);
            }
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    protected boolean isIdle(Stage stage) {
        try {
            Execution execution = (Execution)this.getField(stage, Stage.class, "execution");
            MultiExecutionSerializer executionSerializer = (MultiExecutionSerializer)this.getField(execution, AbstractExecution.class, "executionSerializer");
            return !executionSerializer.isBusy();
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    protected void eventually(Runnable runnable) {
        this.eventually(60000L, runnable);
    }

    protected void eventually(long timeoutMillis, Runnable runnable) {
        this.eventuallyTrue(timeoutMillis, () -> {
            try {
                runnable.run();
                return true;
            }
            catch (Error | RuntimeException ex) {
                return false;
            }
        });
    }

    protected void eventuallyTrue(Callable<Boolean> callable) {
        this.eventuallyTrue(60000L, callable);
    }

    protected void eventuallyTrue(long timeoutMillis, Callable<Boolean> callable) {
        long start = System.currentTimeMillis();
        while (true) {
            block6: {
                try {
                    if (Boolean.TRUE.equals(callable.call())) {
                        return;
                    }
                }
                catch (Exception ex) {
                    if (System.currentTimeMillis() - start <= timeoutMillis) break block6;
                    throw new UncheckedException((Throwable)ex);
                }
            }
            try {
                Thread.sleep(Math.max(200L, (System.currentTimeMillis() - start) / 2L));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @After
    public void tearDown() {
        Task.runAsync(() -> this.stages.stream().filter(s -> s.getState() == NodeCapabilities.NodeState.RUNNING).forEach(s -> {
            try {
                s.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }));
    }

    @FunctionalInterface
    public static interface Exceptional {
        public Object call() throws Throwable;
    }
}

