/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import cloud.orbit.actors.Actor;
import cloud.orbit.actors.Stage;
import cloud.orbit.actors.extensions.ActorExtension;
import cloud.orbit.actors.extensions.json.InMemoryJSONStorageExtension;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.actors.runtime.ActorProfiler;
import cloud.orbit.actors.util.IdUtils;
import cloud.orbit.concurrent.Task;
import cloud.orbit.profiler.CallTreeElement;
import cloud.orbit.profiler.ProfileDump;
import cloud.orbit.profiler.ProfilerData;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;

@State(value=Scope.Benchmark)
@Fork(value=5)
public class SingleNodeBenchmark {
    private Stage stage;
    private ActorProfiler actorProfiler;
    private ScheduledFuture<?> scheduledFuture;
    private ScheduledThreadPoolExecutor scheduledExecutorService;
    int iteration = 0;
    int cpuCount = Runtime.getRuntime().availableProcessors();
    boolean profile = false;
    static final int THROUGHPUT_BENCH_BATCH_SIZE = 500;
    static final int REQ_TIME_BENCH_BATCH_SIZE = 500;

    @Setup
    public void setup() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.out.println("Create stage");
        this.stage = this.createStage();
        if (this.profile) {
            this.actorProfiler = new ActorProfiler();
            this.scheduledExecutorService = new ScheduledThreadPoolExecutor(2);
            this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                try {
                    this.actorProfiler.collect();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }, 1L, 1L, TimeUnit.MILLISECONDS);
        }
    }

    @Setup(value=Level.Iteration)
    public void setupIteration() {
        if (this.profile) {
            ++this.iteration;
            if (this.iteration < 5) {
                this.actorProfiler.clear();
            }
        }
    }

    @TearDown
    public void tearDown() {
        this.stage.stop().join();
        if (this.profile) {
            this.scheduledFuture.cancel(false);
            this.scheduledExecutorService.shutdownNow();
            long collectionCount = this.actorProfiler.getCollectionCount();
            Map profilerSnapshot = this.actorProfiler.getProfilerSnapshot();
            System.out.printf("collectionCount " + collectionCount, new Object[0]);
            for (Map.Entry e : profilerSnapshot.entrySet()) {
                System.out.println("%%%%%%%%%%%%%%%%%%%%");
                System.out.println(e.getKey());
                System.out.println("%%%%%%%%%%%%%%%%%%%%");
                System.out.println(ProfileDump.textMethodInfo((ProfilerData)((ProfilerData)e.getValue()), (long)collectionCount));
                System.out.println("%%%%%%%%%%%%%%%%%%%%");
                System.out.println(e.getKey());
                System.out.println("%%%%%%%%%%%%%%%%%%%%");
                System.out.println(ProfileDump.textDumpCallTree((CallTreeElement)((ProfilerData)e.getValue()).getCallTree(), (long)collectionCount));
                System.out.println();
            }
        }
    }

    @Benchmark
    @Threads(value=-1)
    @BenchmarkMode(value={Mode.Throughput})
    @OperationsPerInvocation(value=500)
    public void requestThroughput() {
        Hello hello = (Hello)Actor.getReference(Hello.class, (String)("hello" + Thread.currentThread().getId()));
        ArrayList<Task<String>> results = new ArrayList<Task<String>>(500);
        for (int i = 0; i < 500; ++i) {
            results.add(hello.sayHello("test"));
        }
        Task result = Task.allOf(results);
        result.join();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Threads(value=1)
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void avgRequestTime_singleThread() {
        Hello hello = (Hello)Actor.getReference(Hello.class, (String)"hello");
        Task<String> result = hello.sayHello("test");
        if (this.cpuCount > 2) {
            while (!result.isDone()) {
            }
        }
        result.join();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Threads(value=1)
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @OperationsPerInvocation(value=500)
    public void avgRequestTime_batched() {
        Hello hello = (Hello)Actor.getReference(Hello.class, (String)"hello");
        ArrayList<Task<String>> results = new ArrayList<Task<String>>(500);
        for (int i = 0; i < 500; ++i) {
            results.add(hello.sayHello("test"));
        }
        Task result = Task.allOf(results);
        result.join();
    }

    private Stage createStage() {
        ConcurrentHashMap fakeDatabase = new ConcurrentHashMap();
        int defaultPoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        Stage stage = new Stage.Builder().extensions(new ActorExtension[]{new InMemoryJSONStorageExtension(fakeDatabase)}).mode(Stage.StageMode.HOST).clusterName(IdUtils.urlSafeString((int)32)).build();
        stage.setExecutionPoolSize(defaultPoolSize);
        stage.start().join();
        stage.bind();
        return stage;
    }

    public static class HelloActor
    extends AbstractActor
    implements Hello {
        @Override
        public Task<String> sayHello(String greeting) {
            return Task.fromValue((Object)greeting);
        }
    }

    public static interface Hello
    extends Actor {
        public Task<String> sayHello(String var1);
    }
}

