/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.test;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;

public class ConcurrentHashMapBenchmark {
    @Benchmark
    @Threads(value=-1)
    public void concurrentHashMap_computeIfAbsent(ConcurrentHashMapState state) {
        state.hashMap.computeIfAbsent(state.key, key -> UUID.randomUUID().toString());
    }

    @Benchmark
    @Threads(value=-1)
    public void concurrentHashMap_getThenComputeIfAbsent(ConcurrentHashMapState state) {
        String value = (String)state.hashMap.get(state.key);
        if (value == null) {
            state.hashMap.computeIfAbsent(state.key, key -> UUID.randomUUID().toString());
        }
    }

    @State(value=Scope.Benchmark)
    public static class ConcurrentHashMapState {
        private final String key = UUID.randomUUID().toString();
        private final ConcurrentHashMap<String, String> hashMap = new ConcurrentHashMap();
    }
}

