/*
 * Decompiled with CFR 0.152.
 */
package org.aerogear.kafka.serialization;

import com.google.protobuf.GeneratedMessageV3;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class ProtoDeserializer<T extends GeneratedMessageV3>
implements Deserializer<T> {
    private Class<T> type;
    private Method parseFromMethod;

    public ProtoDeserializer(Class<T> type) {
        this.type = type;
        try {
            this.parseFromMethod = type.getMethod("parseFrom", byte[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type.toString() + " does not have required method parseFrom(byte[])", e);
        }
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public T deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (T)((GeneratedMessageV3)this.type.cast(this.parseFromMethod.invoke(null, new Object[]{data})));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SerializationException("Unable to deserialize object", (Throwable)e);
        }
    }

    public void close() {
    }
}

